/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.ozone.OzoneRestUtils;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.KeyArgs;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.handlers.UserHandlerBuilder;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.interfaces.UserAuth;
import org.apache.hadoop.ozone.web.utils.OzoneUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class KeyProcessTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(KeyProcessTemplate.class);

    public Response handleCall(String volume, String bucket, String key, Request request, HttpHeaders headers, UriInfo info, InputStream is) throws OzoneException {
        String reqID = OzoneUtils.getRequestID();
        String hostName = OzoneUtils.getHostName();
        MDC.put((String)"component", (String)"ozone");
        MDC.put((String)"request", (String)reqID);
        UserArgs userArgs = null;
        try {
            userArgs = new UserArgs(reqID, hostName, request, info, headers);
            OzoneRestUtils.validate(request, headers, reqID, bucket, hostName);
            OzoneUtils.verifyResourceName((String)bucket);
            UserAuth auth = UserHandlerBuilder.getAuthHandler();
            userArgs.setUserName(auth.getUser(userArgs));
            MDC.put((String)"user", (String)userArgs.getUserName());
            KeyArgs args = new KeyArgs(volume, bucket, key, userArgs);
            MDC.put((String)"resource", (String)args.getResourceName());
            Response response = this.doProcess(args, is, request, headers, info);
            LOG.debug("Success");
            MDC.clear();
            return response;
        }
        catch (IllegalArgumentException argExp) {
            LOG.error("Invalid bucket in key call.", (Throwable)argExp);
            throw ErrorTable.newError(ErrorTable.INVALID_BUCKET_NAME, userArgs, argExp);
        }
        catch (IOException fsExp) {
            LOG.error("IOException:", (Throwable)fsExp);
            if (fsExp.getMessage().endsWith(OzoneManagerProtocolProtos.Status.KEY_NOT_FOUND.name())) {
                throw ErrorTable.newError(ErrorTable.INVALID_KEY, userArgs, fsExp);
            }
            throw ErrorTable.newError(ErrorTable.SERVER_ERROR, userArgs, fsExp);
        }
        catch (NoSuchAlgorithmException algoEx) {
            LOG.error("NoSuchAlgorithmException. Probably indicates an unusual java installation.", (Throwable)algoEx);
            throw ErrorTable.newError(ErrorTable.SERVER_ERROR, userArgs, algoEx);
        }
    }

    public abstract Response doProcess(KeyArgs var1, InputStream var2, Request var3, HttpHeaders var4, UriInfo var5) throws IOException, OzoneException, NoSuchAlgorithmException;

    public void checkFileHashMatch(KeyArgs args, String computedString, StorageHandler fs, String contentHash) throws IOException, OzoneException {
        String contentString;
        if (contentHash != null && !(contentString = new String(Base64.decodeBase64((String)contentHash), OzoneUtils.ENCODING).trim()).equals(computedString)) {
            fs.deleteKey(args);
            OzoneException ex = ErrorTable.newError(ErrorTable.BAD_DIGEST, (UserArgs)args);
            String msg = String.format("MD5 Digest mismatch. Expected %s Found %s", contentString, computedString);
            ex.setMessage(msg);
            LOG.debug(msg);
            throw ex;
        }
    }

    public void checkFileLengthMatch(KeyArgs args, StorageHandler fs, int contentLen, int bytesRead) throws IOException, OzoneException {
        if (bytesRead != contentLen) {
            fs.deleteKey(args);
            OzoneException ex = ErrorTable.newError(ErrorTable.INCOMPLETE_BODY, (UserArgs)args);
            String msg = String.format("Body length mismatch. Expected length : %d Found %d", contentLen, bytesRead);
            ex.setMessage(msg);
            LOG.debug(msg);
            throw ex;
        }
    }

    public String getContentLength(HttpHeaders headers, KeyArgs args) throws OzoneException {
        List contentLengthList = headers.getRequestHeader("Content-Length");
        if (contentLengthList != null && contentLengthList.size() > 0) {
            return (String)contentLengthList.get(0);
        }
        OzoneException ex = ErrorTable.newError(ErrorTable.INVALID_REQUEST, (UserArgs)args);
        ex.setMessage("Content-Length is a required header for putting a key.");
        throw ex;
    }

    public String getContentMD5(HttpHeaders headers, KeyArgs args) {
        List contentLengthList = headers.getRequestHeader("Content-MD5");
        if (contentLengthList != null && contentLengthList.size() > 0) {
            return (String)contentLengthList.get(0);
        }
        return "";
    }
}

