/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.ozone.OzoneRestUtils;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.KeyArgs;
import org.apache.hadoop.ozone.web.handlers.KeyProcessTemplate;
import org.apache.hadoop.ozone.web.handlers.StorageHandlerBuilder;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.ozone.web.interfaces.Keys;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.response.KeyInfo;

public class KeyHandler
implements Keys {
    @Override
    public Response getKey(String volume, String bucket, String key, final String info, Request req, UriInfo uriInfo, HttpHeaders headers) throws OzoneException {
        return new KeyProcessTemplate(){

            @Override
            public Response doProcess(KeyArgs args, InputStream input, Request request, HttpHeaders headers, UriInfo uriInfo) throws IOException, OzoneException, NoSuchAlgorithmException {
                if (info == null) {
                    return KeyHandler.this.getKey(args);
                }
                if (info.equals("key")) {
                    return KeyHandler.this.getKeyInfo(args);
                }
                if (info.equals("key-detail")) {
                    return KeyHandler.this.getKeyInfoDetail(args);
                }
                OzoneException ozException = ErrorTable.newError(ErrorTable.INVALID_QUERY_PARAM, (UserArgs)args);
                ozException.setMessage("Unrecognized query param : " + info);
                throw ozException;
            }
        }.handleCall(volume, bucket, key, req, headers, uriInfo, null);
    }

    private Response getKey(KeyArgs args) throws IOException, OzoneException {
        StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
        LengthInputStream stream = fs.newKeyReader(args);
        return OzoneRestUtils.getResponse((UserArgs)args, 200, stream);
    }

    private Response getKeyInfo(KeyArgs args) throws IOException, OzoneException {
        StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
        KeyInfo keyInfo = fs.getKeyInfo(args);
        return OzoneRestUtils.getResponse((UserArgs)args, 200, keyInfo.toJsonString());
    }

    private Response getKeyInfoDetail(KeyArgs args) throws IOException, OzoneException {
        StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
        KeyInfo keyInfo = fs.getKeyInfoDetails(args);
        return OzoneRestUtils.getResponse((UserArgs)args, 200, keyInfo.toJsonString());
    }

    @Override
    public Response putKey(String volume, String bucket, String keys, InputStream is, Request req, UriInfo info, HttpHeaders headers) throws OzoneException {
        return new KeyProcessTemplate(){

            @Override
            public Response doProcess(KeyArgs args, InputStream input, Request request, HttpHeaders headers, UriInfo info) throws IOException, OzoneException, NoSuchAlgorithmException {
                int eof = -1;
                StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                byte[] buffer = new byte[4096];
                String contentLenString = this.getContentLength(headers, args);
                String newLen = contentLenString.replaceAll("\"", "");
                int contentLen = Integer.parseInt(newLen);
                args.setSize((long)contentLen);
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                int bytesRead = 0;
                int len = 0;
                OutputStream stream = fs.newKeyWriter(args);
                while (bytesRead < contentLen && len != -1) {
                    int readSize = contentLen - bytesRead > buffer.length ? buffer.length : contentLen - bytesRead;
                    len = input.read(buffer, 0, readSize);
                    if (len == -1) continue;
                    stream.write(buffer, 0, len);
                    md5.update(buffer, 0, len);
                    bytesRead += len;
                }
                this.checkFileLengthMatch(args, fs, contentLen, bytesRead);
                String hashString = Hex.encodeHexString((byte[])md5.digest());
                args.setHash(hashString);
                args.setSize((long)bytesRead);
                fs.commitKey(args, stream);
                return OzoneRestUtils.getResponse((UserArgs)args, 201, "");
            }
        }.handleCall(volume, bucket, keys, req, headers, info, is);
    }

    @Override
    public Response deleteKey(String volume, String bucket, String keys, Request req, UriInfo info, HttpHeaders headers) throws OzoneException {
        return new KeyProcessTemplate(){

            @Override
            public Response doProcess(KeyArgs args, InputStream input, Request request, HttpHeaders headers, UriInfo info) throws IOException, OzoneException, NoSuchAlgorithmException {
                StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                fs.deleteKey(args);
                return OzoneRestUtils.getResponse((UserArgs)args, 200, "");
            }
        }.handleCall(volume, bucket, keys, req, headers, info, null);
    }

    @Override
    public Response renameKey(String volume, String bucket, String key, final String toKeyName, Request req, UriInfo info, HttpHeaders headers) throws OzoneException {
        return new KeyProcessTemplate(){

            @Override
            public Response doProcess(KeyArgs args, InputStream input, Request request, HttpHeaders headers, UriInfo info) throws IOException, OzoneException, NoSuchAlgorithmException {
                StorageHandler fs = StorageHandlerBuilder.getStorageHandler();
                fs.renameKey(args, toKeyName);
                return OzoneRestUtils.getResponse((UserArgs)args, 200, "");
            }
        }.handleCall(volume, bucket, key, req, headers, info, null);
    }
}

