/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web;

import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdfs.server.datanode.ObjectStoreHandler;
import org.apache.hadoop.ozone.HddsDatanodeService;
import org.apache.hadoop.ozone.web.netty.ObjectStoreRestHttpServer;
import org.apache.hadoop.util.ServicePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneHddsDatanodeService
implements ServicePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneHddsDatanodeService.class);
    private Configuration conf;
    private ObjectStoreHandler handler;
    private ObjectStoreRestHttpServer objectStoreRestHttpServer;

    public void start(Object service) {
        if (service instanceof HddsDatanodeService) {
            try {
                HddsDatanodeService hddsDatanodeService = (HddsDatanodeService)service;
                this.conf = hddsDatanodeService.getConf();
                this.handler = new ObjectStoreHandler(this.conf);
                this.objectStoreRestHttpServer = new ObjectStoreRestHttpServer(this.conf, null, this.handler);
                this.objectStoreRestHttpServer.start();
                DatanodeDetails.Port restPort = DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.REST, (Integer)this.objectStoreRestHttpServer.getHttpAddress().getPort());
                hddsDatanodeService.getDatanodeDetails().setPort(restPort);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't start the Object Store Rest server", e);
            }
        } else {
            LOG.error("Not starting {}, as the plugin is not invoked through {}", (Object)OzoneHddsDatanodeService.class.getSimpleName(), (Object)HddsDatanodeService.class.getSimpleName());
        }
    }

    public void stop() {
        try {
            this.handler.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't stop the Object Store Rest server", e);
        }
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)this.objectStoreRestHttpServer);
        IOUtils.closeQuietly((Closeable)this.handler);
    }
}

