/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.client.io.LengthInputStream;
import org.apache.hadoop.ozone.client.rest.OzoneException;
import org.apache.hadoop.ozone.web.exceptions.ErrorTable;
import org.apache.hadoop.ozone.web.handlers.UserArgs;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class OzoneRestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneRestUtils.class);
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };

    private OzoneRestUtils() {
    }

    public static void verifyResourceName(String resName) throws IllegalArgumentException {
        HddsClientUtils.verifyResourceName((String)resName);
    }

    public static String getRequestID() {
        return UUID.randomUUID().toString();
    }

    public static void validate(Request request, HttpHeaders headers, String reqId, String resource, String hostname) throws OzoneException {
        List ozHeader = headers.getRequestHeader("x-ozone-version");
        if (ozHeader == null) {
            throw ErrorTable.newError(ErrorTable.MISSING_VERSION, reqId, resource, hostname);
        }
        List date = headers.getRequestHeader("Date");
        if (date == null) {
            throw ErrorTable.newError(ErrorTable.MISSING_DATE, reqId, resource, hostname);
        }
        OzoneRestUtils.parseDate((String)date.get(0), reqId, resource, hostname);
    }

    public static synchronized Date parseDate(String dateString, String reqID, String resource, String hostname) throws OzoneException {
        try {
            return DATE_FORMAT.get().parse(dateString);
        }
        catch (ParseException ex) {
            OzoneException exp = ErrorTable.newError(ErrorTable.BAD_DATE, reqID, resource, hostname);
            exp.setMessage(ex.getMessage());
            throw exp;
        }
    }

    public static Response getResponse(UserArgs args, int statusCode, String payload) {
        String date = DATE_FORMAT.get().format(new Date(Time.now()));
        return Response.ok((Object)payload).header("x-ozone-server-name", (Object)args.getHostName()).header("x-ozone-request-id", (Object)args.getRequestID()).header("Date", (Object)date).status(statusCode).build();
    }

    public static Response getResponse(UserArgs args, int statusCode, LengthInputStream stream) {
        String date = DATE_FORMAT.get().format(new Date(Time.now()));
        return Response.ok((Object)stream, (String)"application/octet-stream").header("x-ozone-server-name", (Object)args.getHostName()).header("x-ozone-request-id", (Object)args.getRequestID()).header("Date", (Object)date).status(statusCode).header("Content-Length", (Object)stream.getLength()).build();
    }

    public static String formatTime(long millis) {
        return DATE_FORMAT.get().format(millis);
    }

    public static long formatDate(String date) throws ParseException {
        Preconditions.checkNotNull((Object)date, (Object)"Date string should not be null.");
        return DATE_FORMAT.get().parse(date).getTime();
    }
}

