/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.api.core.ResourceConfig;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import javax.net.SocketFactory;
import javax.ws.rs.core.Application;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.web.ObjectStoreApplication;
import org.apache.hadoop.ozone.web.handlers.ServiceFilter;
import org.apache.hadoop.ozone.web.interfaces.StorageHandler;
import org.apache.hadoop.ozone.web.netty.ObjectStoreJerseyContainer;
import org.apache.hadoop.ozone.web.storage.DistributedStorageHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectStoreHandler
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStoreHandler.class);
    private final ObjectStoreJerseyContainer objectStoreJerseyContainer;
    private final OzoneManagerProtocolClientSideTranslatorPB ozoneManagerClient;
    private final StorageContainerLocationProtocolClientSideTranslatorPB storageContainerLocationClient;
    private final ScmBlockLocationProtocolClientSideTranslatorPB scmBlockLocationClient;
    private final StorageHandler storageHandler;

    public ObjectStoreHandler(Configuration conf) throws IOException {
        boolean ozoneTrace = conf.getBoolean("ozone.trace.enabled", false);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddress = HddsUtils.getScmAddressForClients((Configuration)conf);
        this.storageContainerLocationClient = new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        InetSocketAddress scmBlockAddress = HddsUtils.getScmAddressForBlockClients((Configuration)conf);
        this.scmBlockLocationClient = new ScmBlockLocationProtocolClientSideTranslatorPB((ScmBlockLocationProtocolPB)RPC.getProxy(ScmBlockLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmBlockAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        RPC.setProtocolEngine((Configuration)conf, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        long omVersion = RPC.getProtocolVersion(OzoneManagerProtocolPB.class);
        InetSocketAddress omAddress = OmUtils.getOmAddress((Configuration)conf);
        this.ozoneManagerClient = new OzoneManagerProtocolClientSideTranslatorPB((OzoneManagerProtocolPB)RPC.getProxy(OzoneManagerProtocolPB.class, (long)omVersion, (InetSocketAddress)omAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        this.storageHandler = new DistributedStorageHandler(new OzoneConfiguration(conf), this.storageContainerLocationClient, this.ozoneManagerClient);
        ApplicationAdapter aa = new ApplicationAdapter((Application)new ObjectStoreApplication());
        HashMap<String, Object> settingsMap = new HashMap<String, Object>();
        settingsMap.put("com.sun.jersey.spi.container.ContainerRequestFilters", ServiceFilter.class.getCanonicalName());
        settingsMap.put("com.sun.jersey.config.feature.Trace", ozoneTrace);
        aa.setPropertiesAndFeatures(settingsMap);
        this.objectStoreJerseyContainer = (ObjectStoreJerseyContainer)ContainerFactory.createContainer(ObjectStoreJerseyContainer.class, (ResourceConfig)aa);
        this.objectStoreJerseyContainer.setStorageHandler(this.storageHandler);
    }

    public ObjectStoreJerseyContainer getObjectStoreJerseyContainer() {
        return this.objectStoreJerseyContainer;
    }

    public StorageHandler getStorageHandler() {
        return this.storageHandler;
    }

    @Override
    public void close() {
        LOG.info("Closing ObjectStoreHandler.");
        this.storageHandler.close();
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.storageContainerLocationClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scmBlockLocationClient});
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.ozoneManagerClient});
    }
}

