/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class ReplicateContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto> {
    private final long containerID;
    private final List<DatanodeDetails> sourceDatanodes;

    public ReplicateContainerCommand(long containerID, List<DatanodeDetails> sourceDatanodes) {
        this.containerID = containerID;
        this.sourceDatanodes = sourceDatanodes;
    }

    public ReplicateContainerCommand(long containerID, List<DatanodeDetails> sourceDatanodes, long id) {
        super(id);
        this.containerID = containerID;
        this.sourceDatanodes = sourceDatanodes;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand;
    }

    @Override
    public byte[] getProtoBufMessage() {
        return this.getProto().toByteArray();
    }

    public StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto getProto() {
        StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto.newBuilder().setCmdId(this.getId()).setContainerID(this.containerID);
        for (DatanodeDetails dd : this.sourceDatanodes) {
            builder.addSources(dd.getProtoBufMessage());
        }
        return builder.build();
    }

    public static ReplicateContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto protoMessage) {
        Preconditions.checkNotNull((Object)protoMessage);
        List<DatanodeDetails> datanodeDetails = protoMessage.getSourcesList().stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList());
        return new ReplicateContainerCommand(protoMessage.getContainerID(), datanodeDetails, protoMessage.getCmdId());
    }

    public long getContainerID() {
        return this.containerID;
    }

    public List<DatanodeDetails> getSourceDatanodes() {
        return this.sourceDatanodes;
    }
}

