/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;

public class RegisteredCommand {
    private String datanodeUUID;
    private String clusterID;
    private StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error;
    private String hostname;
    private String ipAddress;

    public RegisteredCommand(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error, String datanodeUUID, String clusterID) {
        this(error, datanodeUUID, clusterID, null, null);
    }

    public RegisteredCommand(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error, String datanodeUUID, String clusterID, String hostname, String ipAddress) {
        this.datanodeUUID = datanodeUUID;
        this.clusterID = clusterID;
        this.error = error;
        this.hostname = hostname;
        this.ipAddress = ipAddress;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDatanodeUUID() {
        return this.datanodeUUID;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode getError() {
        return this.error;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public byte[] getProtoBufMessage() {
        StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.Builder builder = StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.newBuilder().setClusterID(this.clusterID).setDatanodeUUID(this.datanodeUUID).setErrorCode(this.error);
        if (this.hostname != null && this.ipAddress != null) {
            builder.setHostname(this.hostname).setIpAddress(this.ipAddress);
        }
        return builder.build().toByteArray();
    }

    public static class Builder {
        private String datanodeUUID;
        private String clusterID;
        private StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode error;
        private String ipAddress;
        private String hostname;

        public Builder setDatanodeUUID(String dnUUID) {
            this.datanodeUUID = dnUUID;
            return this;
        }

        public RegisteredCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto response) {
            Preconditions.checkNotNull((Object)response);
            if (response.hasHostname() && response.hasIpAddress()) {
                return new RegisteredCommand(response.getErrorCode(), response.getDatanodeUUID(), response.getClusterID(), response.getHostname(), response.getIpAddress());
            }
            return new RegisteredCommand(response.getErrorCode(), response.getDatanodeUUID(), response.getClusterID());
        }

        public Builder setClusterID(String cluster) {
            this.clusterID = cluster;
            return this;
        }

        public Builder setErrorCode(StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode errorCode) {
            this.error = errorCode;
            return this;
        }

        public Builder setHostname(String host) {
            this.hostname = host;
            return this;
        }

        public Builder setIpAddress(String ipAddr) {
            this.ipAddress = ipAddr;
            return this;
        }

        public RegisteredCommand build() {
            if (this.error == StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto.ErrorCode.success && (this.datanodeUUID == null || this.datanodeUUID.isEmpty()) || this.clusterID == null || this.clusterID.isEmpty()) {
                throw new IllegalArgumentException("On success, RegisteredCommand needs datanodeUUID and ClusterID.");
            }
            if (this.hostname != null && this.ipAddress != null) {
                return new RegisteredCommand(this.error, this.datanodeUUID, this.clusterID, this.hostname, this.ipAddress);
            }
            return new RegisteredCommand(this.error, this.datanodeUUID, this.clusterID);
        }
    }
}

