/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class CloseContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto> {
    private HddsProtos.ReplicationType replicationType;
    private PipelineID pipelineID;

    public CloseContainerCommand(long containerID, HddsProtos.ReplicationType replicationType, PipelineID pipelineID) {
        super(containerID);
        this.replicationType = replicationType;
        this.pipelineID = pipelineID;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand;
    }

    @Override
    public byte[] getProtoBufMessage() {
        return this.getProto().toByteArray();
    }

    public StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto getProto() {
        return StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto.newBuilder().setContainerID(this.getId()).setCmdId(this.getId()).setReplicationType(this.replicationType).setPipelineID(this.pipelineID.getProtobuf()).build();
    }

    public static CloseContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto closeContainerProto) {
        Preconditions.checkNotNull((Object)closeContainerProto);
        return new CloseContainerCommand(closeContainerProto.getCmdId(), closeContainerProto.getReplicationType(), PipelineID.getFromProtobuf((HddsProtos.PipelineID)closeContainerProto.getPipelineID()));
    }

    public long getContainerID() {
        return this.getId();
    }
}

