/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.ozone.container.replication.ContainerDownloader;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleContainerDownloader
implements ContainerDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleContainerDownloader.class);
    private final Path workingDirectory;
    private ExecutorService executor;

    public SimpleContainerDownloader(Configuration conf) {
        String workDirString = conf.get("hdds.datanode.replication.work.dir");
        this.workingDirectory = workDirString == null ? Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve("container-copy") : Paths.get(workDirString, new String[0]);
        ThreadFactory build = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Container downloader thread - %d").build();
        this.executor = Executors.newSingleThreadExecutor(build);
        LOG.info("Starting container downloader service to copy containers to replicate.");
    }

    @Override
    public CompletableFuture<Path> getContainerDataFromReplicas(long containerId, List<DatanodeDetails> sourceDatanodes) {
        CompletableFuture<Path> result = null;
        for (DatanodeDetails datanode : sourceDatanodes) {
            try {
                if (result == null) {
                    GrpcReplicationClient grpcReplicationClient = new GrpcReplicationClient(datanode.getIpAddress(), datanode.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue(), this.workingDirectory);
                    result = grpcReplicationClient.download(containerId);
                    continue;
                }
                result = ((CompletableFuture)((CompletableFuture)result.thenApply(CompletableFuture::completedFuture)).exceptionally(t -> {
                    LOG.error("Error on replicating container: " + containerId, t);
                    GrpcReplicationClient grpcReplicationClient = new GrpcReplicationClient(datanode.getIpAddress(), datanode.getPort(DatanodeDetails.Port.Name.STANDALONE).getValue(), this.workingDirectory);
                    return grpcReplicationClient.download(containerId);
                })).thenCompose(Function.identity());
            }
            catch (Exception ex) {
                LOG.error(String.format("Container %s download from datanode %s was unsuccessful. Trying the next datanode", containerId, datanode), (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Can't stop container downloader gracefully", (Throwable)e);
        }
    }
}

