/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationSupervisor {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationSupervisor.class);
    private final Set<Worker> threadPool = new HashSet<Worker>();
    private final Map<Long, ReplicationTask> queue = new TreeMap<Long, ReplicationTask>();
    private final ContainerSet containerSet;
    private final ContainerReplicator replicator;
    private final int poolSize;

    public ReplicationSupervisor(ContainerSet containerSet, ContainerReplicator replicator, int poolSize) {
        this.containerSet = containerSet;
        this.replicator = replicator;
        this.poolSize = poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addTask(ReplicationTask task) {
        this.queue.putIfAbsent(task.getContainerId(), task);
        Set<Worker> set = this.threadPool;
        synchronized (set) {
            this.threadPool.notify();
        }
    }

    public void start() {
        for (int i = 0; i < this.poolSize; ++i) {
            Worker worker = new Worker();
            Thread thread = new Thread((Runnable)worker, "ContainerReplication-" + i);
            thread.setDaemon(true);
            thread.start();
            this.threadPool.add(worker);
        }
    }

    public synchronized ReplicationTask selectTask() {
        for (ReplicationTask task : this.queue.values()) {
            if (task.getStatus() == ReplicationTask.Status.QUEUED) {
                if (this.containerSet.getContainer(task.getContainerId()) == null) {
                    task.setStatus(ReplicationTask.Status.DOWNLOADING);
                    return task;
                }
                LOG.debug("Container {} has already been downloaded.", (Object)task.getContainerId());
                this.queue.remove(task.getContainerId());
                continue;
            }
            if (task.getStatus() == ReplicationTask.Status.FAILED) {
                LOG.error("Container {} can't be downloaded from any of the datanodes.", (Object)task.getContainerId());
                this.queue.remove(task.getContainerId());
                continue;
            }
            if (task.getStatus() != ReplicationTask.Status.DONE) continue;
            this.queue.remove(task.getContainerId());
            LOG.info("Container {} is replicated.", (Object)task.getContainerId());
        }
        return null;
    }

    public void stop() {
        for (Worker worker : this.threadPool) {
            worker.stop();
        }
    }

    @VisibleForTesting
    public int getQueueSize() {
        return this.queue.size();
    }

    private class Worker
    implements Runnable {
        private boolean running = true;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.running) {
                    ReplicationTask task = ReplicationSupervisor.this.selectTask();
                    if (task == null) {
                        Set set = ReplicationSupervisor.this.threadPool;
                        synchronized (set) {
                            ReplicationSupervisor.this.threadPool.wait();
                            continue;
                        }
                    }
                    ReplicationSupervisor.this.replicator.replicate(task);
                }
                return;
            }
            catch (Exception ex) {
                LOG.error("Error on doing replication", (Throwable)ex);
                try {
                    Thread.sleep(200L);
                    return;
                }
                catch (InterruptedException e) {
                    LOG.error("Error on waiting after failed replication task", (Throwable)e);
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

