/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerPacker;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.replication.ContainerReplicationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnDemandContainerReplicationSource
implements ContainerReplicationSource {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerReplicationSource.class);
    private ContainerSet containerSet;
    private ContainerPacker packer = new TarContainerPacker();

    public OnDemandContainerReplicationSource(ContainerSet containerSet) {
        this.containerSet = containerSet;
    }

    @Override
    public void prepare(long containerId) {
    }

    @Override
    public void copyData(long containerId, OutputStream destination) throws IOException {
        Container container = this.containerSet.getContainer(containerId);
        Preconditions.checkNotNull((Object)container, (Object)("Container is not found " + containerId));
        switch (container.getContainerType()) {
            case KeyValueContainer: {
                this.packer.pack(container, destination);
                break;
            }
            default: {
                LOG.warn("Container type " + container.getContainerType() + " is not replicable as no compression algorithm for that.");
            }
        }
    }
}

