/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.replication;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataYaml;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.keyvalue.TarContainerPacker;
import org.apache.hadoop.ozone.container.replication.ContainerDownloader;
import org.apache.hadoop.ozone.container.replication.ContainerReplicator;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadAndImportReplicator
implements ContainerReplicator {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadAndImportReplicator.class);
    private final ContainerSet containerSet;
    private final ContainerDispatcher containerDispatcher;
    private final ContainerDownloader downloader;
    private final TarContainerPacker packer;

    public DownloadAndImportReplicator(ContainerSet containerSet, ContainerDispatcher containerDispatcher, ContainerDownloader downloader, TarContainerPacker packer) {
        this.containerSet = containerSet;
        this.containerDispatcher = containerDispatcher;
        this.downloader = downloader;
        this.packer = packer;
    }

    public void importContainer(long containerID, Path tarFilePath) {
        try {
            ContainerData originalContainerData;
            try (FileInputStream tempContainerTarStream = new FileInputStream(tarFilePath.toFile());){
                byte[] containerDescriptorYaml = this.packer.unpackContainerDescriptor(tempContainerTarStream);
                originalContainerData = ContainerDataYaml.readContainer(containerDescriptorYaml);
            }
            tempContainerTarStream = new FileInputStream(tarFilePath.toFile());
            var6_5 = null;
            try {
                Handler handler = this.containerDispatcher.getHandler(originalContainerData.getContainerType());
                Container container = handler.importContainer(containerID, originalContainerData.getMaxSize(), tempContainerTarStream, this.packer);
                this.containerSet.addContainer(container);
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (tempContainerTarStream != null) {
                    if (var6_5 != null) {
                        try {
                            tempContainerTarStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        tempContainerTarStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Can't import the downloaded container data id=" + containerID, (Throwable)e);
            try {
                Files.delete(tarFilePath);
            }
            catch (Exception ex) {
                LOG.error("Container import is failed and the downloaded file can't be deleted: " + tarFilePath.toAbsolutePath().toString());
            }
        }
    }

    @Override
    public void replicate(ReplicationTask task) {
        long containerID = task.getContainerId();
        List<DatanodeDetails> sourceDatanodes = task.getSources();
        LOG.info("Starting replication of container {} from {}", (Object)containerID, sourceDatanodes);
        CompletableFuture<Path> tempTarFile = this.downloader.getContainerDataFromReplicas(containerID, sourceDatanodes);
        try {
            Path path = tempTarFile.get();
            LOG.info("Container {} is downloaded, starting to import.", (Object)containerID);
            this.importContainer(containerID, path);
            LOG.info("Container {} is replicated successfully", (Object)containerID);
            task.setStatus(ReplicationTask.Status.DONE);
        }
        catch (Exception e) {
            LOG.error("Container replication was unsuccessful .", (Throwable)e);
            task.setStatus(ReplicationTask.Status.FAILED);
        }
    }
}

