/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ozoneimpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerGrpc;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerReader;
import org.apache.hadoop.ozone.container.replication.GrpcReplicationService;
import org.apache.hadoop.ozone.container.replication.OnDemandContainerReplicationSource;
import org.apache.ratis.shaded.io.grpc.BindableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneContainer {
    public static final Logger LOG = LoggerFactory.getLogger(OzoneContainer.class);
    private final HddsDispatcher hddsDispatcher;
    private final DatanodeDetails dnDetails;
    private final OzoneConfiguration config;
    private final VolumeSet volumeSet;
    private final ContainerSet containerSet;
    private final Map<HddsProtos.ReplicationType, XceiverServerSpi> servers;

    public OzoneContainer(DatanodeDetails datanodeDetails, OzoneConfiguration conf, StateContext context) throws IOException {
        this.dnDetails = datanodeDetails;
        this.config = conf;
        this.volumeSet = new VolumeSet(datanodeDetails.getUuidString(), (Configuration)conf);
        this.containerSet = new ContainerSet();
        this.buildContainerSet();
        this.hddsDispatcher = new HddsDispatcher((Configuration)this.config, this.containerSet, this.volumeSet, context);
        this.servers = new HashMap<HddsProtos.ReplicationType, XceiverServerSpi>();
        this.servers.put(HddsProtos.ReplicationType.STAND_ALONE, new XceiverServerGrpc(datanodeDetails, (Configuration)this.config, this.hddsDispatcher, new BindableService[]{this.createReplicationService()}));
        this.servers.put(HddsProtos.ReplicationType.RATIS, XceiverServerRatis.newXceiverServerRatis(datanodeDetails, (Configuration)this.config, this.hddsDispatcher, context));
    }

    private GrpcReplicationService createReplicationService() {
        return new GrpcReplicationService(new OnDemandContainerReplicationSource(this.containerSet));
    }

    public void buildContainerSet() {
        Iterator<HddsVolume> volumeSetIterator = this.volumeSet.getVolumesList().iterator();
        ArrayList<Thread> volumeThreads = new ArrayList<Thread>();
        while (volumeSetIterator.hasNext()) {
            HddsVolume volume = volumeSetIterator.next();
            File hddsVolumeRootDir = volume.getHddsRootDir();
            Thread thread = new Thread(new ContainerReader(this.volumeSet, volume, this.containerSet, this.config));
            thread.start();
            volumeThreads.add(thread);
        }
        try {
            for (int i = 0; i < volumeThreads.size(); ++i) {
                ((Thread)volumeThreads.get(i)).join();
            }
        }
        catch (InterruptedException ex) {
            LOG.info("Volume Threads Interrupted exception", (Throwable)ex);
        }
    }

    public void start() throws IOException {
        LOG.info("Attempting to start container services.");
        for (XceiverServerSpi serverinstance : this.servers.values()) {
            serverinstance.start();
        }
        this.hddsDispatcher.init();
    }

    public void stop() {
        LOG.info("Attempting to stop container services.");
        for (XceiverServerSpi serverinstance : this.servers.values()) {
            serverinstance.stop();
        }
        this.hddsDispatcher.shutdown();
    }

    @VisibleForTesting
    public ContainerSet getContainerSet() {
        return this.containerSet;
    }

    public StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReport() throws IOException {
        return this.containerSet.getContainerReport();
    }

    public StorageContainerDatanodeProtocolProtos.PipelineReportsProto getPipelineReport() {
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto.Builder pipelineReportsProto = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder();
        for (XceiverServerSpi serverInstance : this.servers.values()) {
            pipelineReportsProto.addAllPipelineReport(serverInstance.getPipelineReport());
        }
        return pipelineReportsProto.build();
    }

    public void submitContainerRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.ReplicationType replicationType, HddsProtos.PipelineID pipelineID) throws IOException {
        if (((ContainerData)this.containerSet.getContainer(request.getContainerID()).getContainerData()).isClosed()) {
            LOG.debug("Container {} is already closed", (Object)request.getContainerID());
        }
        LOG.info("submitting {} request over {} server for container {}", new Object[]{request.getCmdType(), replicationType, request.getContainerID()});
        Preconditions.checkState((boolean)this.servers.containsKey(replicationType));
        this.servers.get(replicationType).submitRequest(request, pipelineID);
    }

    private int getPortByType(HddsProtos.ReplicationType replicationType) {
        return this.servers.containsKey(replicationType) ? this.servers.get(replicationType).getIPCPort() : -1;
    }

    public int getContainerServerPort() {
        return this.getPortByType(HddsProtos.ReplicationType.STAND_ALONE);
    }

    public int getRatisContainerServerPort() {
        return this.getPortByType(HddsProtos.ReplicationType.RATIS);
    }

    public StorageContainerDatanodeProtocolProtos.NodeReportProto getNodeReport() throws IOException {
        return this.volumeSet.getNodeReport();
    }

    @VisibleForTesting
    public ContainerDispatcher getDispatcher() {
        return this.hddsDispatcher;
    }

    public VolumeSet getVolumeSet() {
        return this.volumeSet;
    }
}

