/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.statemachine.background;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.impl.TopNOrderedContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.BackgroundTask;
import org.apache.hadoop.utils.BackgroundTaskQueue;
import org.apache.hadoop.utils.BackgroundTaskResult;
import org.apache.hadoop.utils.BatchOperation;
import org.apache.hadoop.utils.MetadataKeyFilters;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.ratis.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDeletingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(BlockDeletingService.class);
    ContainerSet containerSet;
    private ContainerDeletionChoosingPolicy containerDeletionPolicy;
    private final Configuration conf;
    private final int blockLimitPerTask;
    private final int containerLimitPerInterval;
    private static final int TASK_PRIORITY_DEFAULT = 1;
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 10;

    public BlockDeletingService(ContainerSet containerSet, long serviceInterval, long serviceTimeout, TimeUnit timeUnit, Configuration conf) {
        super("BlockDeletingService", serviceInterval, timeUnit, 10, serviceTimeout);
        this.containerSet = containerSet;
        this.containerDeletionPolicy = (ContainerDeletionChoosingPolicy)ReflectionUtils.newInstance((Class)conf.getClass("ozone.scm.keyvalue.container.deletion-choosing.policy", TopNOrderedContainerDeletionChoosingPolicy.class, ContainerDeletionChoosingPolicy.class), (Configuration)conf);
        this.conf = conf;
        this.blockLimitPerTask = conf.getInt("ozone.block.deleting.limit.per.task", 1000);
        this.containerLimitPerInterval = conf.getInt("ozone.block.deleting.container.limit.per.interval", 10);
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue;
        block5: {
            queue = new BackgroundTaskQueue();
            List<Object> containers = Lists.newArrayList();
            try {
                containers = this.containerSet.chooseContainerForBlockDeletion(this.containerLimitPerInterval, this.containerDeletionPolicy);
                if (containers.size() > 0) {
                    LOG.info("Plan to choose {} containers for block deletion, actually returns {} valid containers.", (Object)this.containerLimitPerInterval, (Object)containers.size());
                }
                for (ContainerData containerData : containers) {
                    BlockDeletingTask containerTask = new BlockDeletingTask(containerData, 1);
                    queue.add((BackgroundTask)containerTask);
                }
            }
            catch (StorageContainerException e) {
                LOG.warn("Failed to initiate block deleting tasks, caused by unable to get containers info. Retry in next interval. ", (Throwable)e);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Unexpected error occurs during deleting blocks.", (Throwable)e);
            }
        }
        return queue;
    }

    private class BlockDeletingTask
    implements BackgroundTask<BackgroundTaskResult> {
        private final int priority;
        private final KeyValueContainerData containerData;

        BlockDeletingTask(ContainerData containerName, int priority) {
            this.priority = priority;
            this.containerData = (KeyValueContainerData)containerName;
        }

        public BackgroundTaskResult call() throws Exception {
            ContainerBackgroundTaskResult crr = new ContainerBackgroundTaskResult();
            long startTime = Time.monotonicNow();
            MetadataStore meta = KeyUtils.getDB(this.containerData, BlockDeletingService.this.conf);
            MetadataKeyFilters.KeyPrefixFilter filter = new MetadataKeyFilters.KeyPrefixFilter().addFilter("#deleting#");
            List toDeleteBlocks = meta.getSequentialRangeKVs(null, BlockDeletingService.this.blockLimitPerTask, new MetadataKeyFilters.MetadataKeyFilter[]{filter});
            if (toDeleteBlocks.isEmpty()) {
                LOG.debug("No under deletion block found in container : {}", (Object)this.containerData.getContainerID());
            }
            LinkedList<String> succeedBlocks = new LinkedList<String>();
            LOG.debug("Container : {}, To-Delete blocks : {}", (Object)this.containerData.getContainerID(), (Object)toDeleteBlocks.size());
            File dataDir = new File(this.containerData.getChunksPath());
            if (!dataDir.exists() || !dataDir.isDirectory()) {
                LOG.error("Invalid container data dir {} : does not exist or not a directory", (Object)dataDir.getAbsolutePath());
                return crr;
            }
            toDeleteBlocks.forEach(entry -> {
                String blockName = DFSUtil.bytes2String((byte[])((byte[])entry.getKey()));
                LOG.debug("Deleting block {}", (Object)blockName);
                try {
                    ContainerProtos.KeyData data = ContainerProtos.KeyData.parseFrom((byte[])((byte[])entry.getValue()));
                    for (ContainerProtos.ChunkInfo chunkInfo : data.getChunksList()) {
                        File chunkFile = dataDir.toPath().resolve(chunkInfo.getChunkName()).toFile();
                        if (!FileUtils.deleteQuietly((File)chunkFile)) continue;
                        LOG.debug("block {} chunk {} deleted", (Object)blockName, (Object)chunkFile.getAbsolutePath());
                    }
                    succeedBlocks.add(blockName);
                }
                catch (InvalidProtocolBufferException e) {
                    LOG.error("Failed to parse block info for block {}", (Object)blockName, (Object)e);
                }
            });
            BatchOperation batch = new BatchOperation();
            succeedBlocks.forEach(entry -> {
                String blockId = entry.substring("#deleting#".length());
                String deletedEntry = "#deleted#" + blockId;
                batch.put(DFSUtil.string2Bytes((String)deletedEntry), DFSUtil.string2Bytes((String)blockId));
                batch.delete(DFSUtil.string2Bytes((String)entry));
            });
            meta.writeBatch(batch);
            this.containerData.decrPendingDeletionBlocks(succeedBlocks.size());
            if (!succeedBlocks.isEmpty()) {
                LOG.info("Container: {}, deleted blocks: {}, task elapsed time: {}ms", new Object[]{this.containerData.getContainerID(), succeedBlocks.size(), Time.monotonicNow() - startTime});
            }
            crr.addAll(succeedBlocks);
            return crr;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private static class ContainerBackgroundTaskResult
    implements BackgroundTaskResult {
        private List<String> deletedBlockIds = new LinkedList<String>();

        ContainerBackgroundTaskResult() {
        }

        public void addBlockId(String blockId) {
            this.deletedBlockIds.add(blockId);
        }

        public void addAll(List<String> blockIds) {
            this.deletedBlockIds.addAll(blockIds);
        }

        public List<String> getDeletedBlocks() {
            return this.deletedBlockIds;
        }

        public int getSize() {
            return this.deletedBlockIds.size();
        }
    }
}

