/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.KeyData;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyUtils;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.KeyManager;
import org.apache.hadoop.utils.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    static final Logger LOG = LoggerFactory.getLogger(KeyManagerImpl.class);
    private Configuration config;

    public KeyManagerImpl(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Config cannot be null");
        this.config = conf;
    }

    @Override
    public long putKey(Container container, KeyData data) throws IOException {
        Preconditions.checkNotNull((Object)data, (Object)"KeyData cannot be null for put operation.");
        Preconditions.checkState((data.getContainerID() >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative");
        MetadataStore db = KeyUtils.getDB((KeyValueContainerData)container.getContainerData(), this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        db.put(Longs.toByteArray((long)data.getLocalID()), data.getProtoBufMessage().toByteArray());
        ((ContainerData)container.getContainerData()).incrKeyCount();
        return data.getSize();
    }

    @Override
    public KeyData getKey(Container container, BlockID blockID) throws IOException {
        Preconditions.checkNotNull((Object)blockID, (Object)"BlockID cannot be null in GetKet request");
        Preconditions.checkNotNull((Object)blockID.getContainerID(), (Object)"Container name cannot be null");
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = KeyUtils.getDB(containerData, this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        byte[] kData = db.get(Longs.toByteArray((long)blockID.getLocalID()));
        if (kData == null) {
            throw new StorageContainerException("Unable to find the key.", ContainerProtos.Result.NO_SUCH_KEY);
        }
        ContainerProtos.KeyData keyData = ContainerProtos.KeyData.parseFrom((byte[])kData);
        return KeyData.getFromProtoBuf((ContainerProtos.KeyData)keyData);
    }

    @Override
    public long getCommittedBlockLength(Container container, BlockID blockID) throws IOException {
        KeyValueContainerData containerData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = KeyUtils.getDB(containerData, this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        byte[] kData = db.get(Longs.toByteArray((long)blockID.getLocalID()));
        if (kData == null) {
            throw new StorageContainerException("Unable to find the key.", ContainerProtos.Result.NO_SUCH_KEY);
        }
        ContainerProtos.KeyData keyData = ContainerProtos.KeyData.parseFrom((byte[])kData);
        return keyData.getSize();
    }

    @Override
    public void deleteKey(Container container, BlockID blockID) throws IOException {
        Preconditions.checkNotNull((Object)blockID, (Object)"block ID cannot be null.");
        Preconditions.checkState((blockID.getContainerID() >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        Preconditions.checkState((blockID.getLocalID() >= 0L ? 1 : 0) != 0, (Object)"Local ID cannot be negative.");
        KeyValueContainerData cData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = KeyUtils.getDB(cData, this.config);
        Preconditions.checkNotNull((Object)db, (Object)"DB cannot be null here");
        byte[] kKey = Longs.toByteArray((long)blockID.getLocalID());
        byte[] kData = db.get(kKey);
        if (kData == null) {
            throw new StorageContainerException("Unable to find the key.", ContainerProtos.Result.NO_SUCH_KEY);
        }
        db.delete(kKey);
        ((ContainerData)container.getContainerData()).decrKeyCount();
    }

    @Override
    public List<KeyData> listKey(Container container, long startLocalID, int count) throws IOException {
        Preconditions.checkNotNull((Object)container, (Object)"container cannot be null");
        Preconditions.checkState((startLocalID >= 0L ? 1 : 0) != 0, (Object)"startLocal ID cannot be negative");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be a positive number.");
        container.readLock();
        ArrayList<KeyData> result = null;
        KeyValueContainerData cData = (KeyValueContainerData)container.getContainerData();
        MetadataStore db = KeyUtils.getDB(cData, this.config);
        result = new ArrayList<KeyData>();
        byte[] startKeyInBytes = Longs.toByteArray((long)startLocalID);
        List range = db.getSequentialRangeKVs(startKeyInBytes, count, null);
        for (Map.Entry entry : range) {
            KeyData value = KeyUtils.getKeyData((byte[])entry.getValue());
            KeyData data = new KeyData(value.getBlockID());
            result.add(data);
        }
        return result;
    }

    @Override
    public void shutdown() {
        KeyUtils.shutdownCache(ContainerCache.getInstance(this.config));
    }
}

