/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.helpers.KeyData;
import org.apache.hadoop.ozone.container.common.utils.ContainerCache;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.utils.MetadataStore;

public final class KeyUtils {
    private KeyUtils() {
    }

    public static MetadataStore getDB(KeyValueContainerData containerData, Configuration conf) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        Preconditions.checkNotNull((Object)containerData.getDbFile());
        try {
            return cache.getDB(containerData.getContainerID(), containerData.getContainerDBType(), containerData.getDbFile().getAbsolutePath());
        }
        catch (IOException ex) {
            String message = String.format("Error opening DB. Container:%s ContainerPath:%s", containerData.getContainerID(), containerData.getDbFile().getPath());
            throw new StorageContainerException(message, ContainerProtos.Result.UNABLE_TO_READ_METADATA_DB);
        }
    }

    public static void removeDB(KeyValueContainerData container, Configuration conf) {
        Preconditions.checkNotNull((Object)container);
        ContainerCache cache = ContainerCache.getInstance(conf);
        Preconditions.checkNotNull((Object)((Object)cache));
        cache.removeDB(container.getContainerID());
    }

    public static void shutdownCache(ContainerCache cache) {
        cache.shutdownCache();
    }

    public static KeyData getKeyData(byte[] bytes) throws IOException {
        try {
            ContainerProtos.KeyData keyData = ContainerProtos.KeyData.parseFrom((byte[])bytes);
            KeyData data = KeyData.getFromProtoBuf((ContainerProtos.KeyData)keyData);
            return data;
        }
        catch (IOException e) {
            throw new StorageContainerException("Failed to parse key data from the bytes array.", ContainerProtos.Result.NO_SUCH_KEY);
        }
    }

    public static ContainerProtos.ContainerCommandResponseProto putKeyResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg, long blockLength) {
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder committedBlockLengthResponseBuilder = KeyUtils.getCommittedBlockLengthResponseBuilder(blockLength, msg.getPutKey().getKeyData().getBlockID());
        ContainerProtos.PutKeyResponseProto.Builder putKeyResponse = ContainerProtos.PutKeyResponseProto.newBuilder();
        putKeyResponse.setCommittedBlockLength(committedBlockLengthResponseBuilder);
        ContainerProtos.ContainerCommandResponseProto.Builder builder = ContainerUtils.getSuccessResponseBuilder(msg);
        builder.setPutKey(putKeyResponse);
        return builder.build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getKeyResponseSuccess(ContainerProtos.ContainerCommandRequestProto msg) {
        return ContainerUtils.getSuccessResponse(msg);
    }

    public static ContainerProtos.ContainerCommandResponseProto getKeyDataResponse(ContainerProtos.ContainerCommandRequestProto msg, KeyData data) {
        ContainerProtos.GetKeyResponseProto.Builder getKey = ContainerProtos.GetKeyResponseProto.newBuilder();
        getKey.setKeyData(data.getProtoBufMessage());
        ContainerProtos.ContainerCommandResponseProto.Builder builder = ContainerUtils.getSuccessResponseBuilder(msg);
        builder.setGetKey(getKey);
        return builder.build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getBlockLengthResponse(ContainerProtos.ContainerCommandRequestProto msg, long blockLength) {
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder committedBlockLengthResponseBuilder = KeyUtils.getCommittedBlockLengthResponseBuilder(blockLength, msg.getGetCommittedBlockLength().getBlockID());
        ContainerProtos.ContainerCommandResponseProto.Builder builder = ContainerUtils.getSuccessResponseBuilder(msg);
        builder.setGetCommittedBlockLength(committedBlockLengthResponseBuilder);
        return builder.build();
    }

    private static ContainerProtos.GetCommittedBlockLengthResponseProto.Builder getCommittedBlockLengthResponseBuilder(long blockLength, ContainerProtos.DatanodeBlockID blockID) {
        ContainerProtos.GetCommittedBlockLengthResponseProto.Builder getCommittedBlockLengthResponseBuilder = ContainerProtos.GetCommittedBlockLengthResponseProto.newBuilder();
        getCommittedBlockLengthResponseBuilder.setBlockLength(blockLength);
        getCommittedBlockLengthResponseBuilder.setBlockID(blockID);
        return getCommittedBlockLengthResponseBuilder;
    }
}

