/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.utils.MetadataStore;
import org.apache.hadoop.utils.MetadataStoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerCache
extends LRUMap {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerCache.class);
    private final Lock lock = new ReentrantLock();
    private static ContainerCache cache;
    private static final float LOAD_FACTOR = 0.75f;

    private ContainerCache(int maxSize, float loadFactor, boolean scanUntilRemovable) {
        super(maxSize, loadFactor, scanUntilRemovable);
    }

    public static synchronized ContainerCache getInstance(Configuration conf) {
        if (cache == null) {
            int cacheSize = conf.getInt("ozone.container.cache.size", 1024);
            cache = new ContainerCache(cacheSize, 0.75f, true);
        }
        return cache;
    }

    private void closeDB(long containerID, MetadataStore db) {
        if (db != null) {
            try {
                db.close();
            }
            catch (IOException e) {
                LOG.error("Error closing DB. Container: " + containerID, (Throwable)e);
            }
        }
    }

    public void shutdownCache() {
        this.lock.lock();
        try {
            MapIterator iterator = cache.mapIterator();
            while (iterator.hasNext()) {
                iterator.next();
                MetadataStore db = (MetadataStore)iterator.getValue();
                this.closeDB(((Number)iterator.getKey()).longValue(), db);
            }
            cache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean removeLRU(AbstractLinkedMap.LinkEntry entry) {
        this.lock.lock();
        try {
            MetadataStore db = (MetadataStore)entry.getValue();
            this.closeDB(((Number)entry.getKey()).longValue(), db);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public MetadataStore getDB(long containerID, String containerDBType, String containerDBPath) throws IOException {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        this.lock.lock();
        try {
            MetadataStore db = (MetadataStore)this.get(containerID);
            if (db == null) {
                db = MetadataStoreBuilder.newBuilder().setDbFile(new File(containerDBPath)).setCreateIfMissing(false).setDBType(containerDBType).build();
                this.put(containerID, db);
            }
            MetadataStore metadataStore = db;
            return metadataStore;
        }
        catch (Exception e) {
            LOG.error("Error opening DB. Container:{} ContainerPath:{}", new Object[]{containerID, containerDBPath, e});
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDB(long containerID) {
        Preconditions.checkState((containerID >= 0L ? 1 : 0) != 0, (Object)"Container ID cannot be negative.");
        this.lock.lock();
        try {
            MetadataStore db = (MetadataStore)this.get(containerID);
            this.closeDB(containerID, db);
            this.remove(containerID);
        }
        finally {
            this.lock.unlock();
        }
    }
}

