/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.CSMMetrics;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.shaded.com.google.protobuf.ByteString;
import org.apache.ratis.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.shaded.proto.RaftProtos;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.StateMachineStorage;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.statemachine.impl.TransactionContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerStateMachine
extends BaseStateMachine {
    static final Logger LOG = LoggerFactory.getLogger(ContainerStateMachine.class);
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final ContainerDispatcher dispatcher;
    private ThreadPoolExecutor chunkExecutor;
    private final XceiverServerRatis ratisServer;
    private final ConcurrentHashMap<Long, CompletableFuture<Message>> writeChunkFutureMap;
    private final ConcurrentHashMap<Long, StateMachineHelper> stateMachineMap;
    private final CSMMetrics metrics;

    public ContainerStateMachine(ContainerDispatcher dispatcher, ThreadPoolExecutor chunkExecutor, XceiverServerRatis ratisServer) {
        this.dispatcher = dispatcher;
        this.chunkExecutor = chunkExecutor;
        this.ratisServer = ratisServer;
        this.writeChunkFutureMap = new ConcurrentHashMap();
        this.stateMachineMap = new ConcurrentHashMap();
        this.metrics = CSMMetrics.create();
    }

    public StateMachineStorage getStateMachineStorage() {
        return this.storage;
    }

    public CSMMetrics getMetrics() {
        return this.metrics;
    }

    public void initialize(RaftServer server, RaftGroupId id, RaftStorage raftStorage) throws IOException {
        super.initialize(server, id, raftStorage);
        this.storage.init(raftStorage);
    }

    public TransactionContext startTransaction(RaftClientRequest request) throws IOException {
        RaftProtos.SMLogEntryProto log;
        ContainerProtos.ContainerCommandRequestProto proto = this.getRequestProto(request.getMessage().getContent());
        if (proto.getCmdType() == ContainerProtos.Type.WriteChunk) {
            ContainerProtos.WriteChunkRequestProto write = proto.getWriteChunk();
            ContainerProtos.WriteChunkRequestProto dataWriteChunkProto = ContainerProtos.WriteChunkRequestProto.newBuilder((ContainerProtos.WriteChunkRequestProto)write).setStage(ContainerProtos.Stage.WRITE_DATA).build();
            ContainerProtos.ContainerCommandRequestProto dataContainerCommandProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)proto).setWriteChunk(dataWriteChunkProto).build();
            ContainerProtos.WriteChunkRequestProto commitWriteChunkProto = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(write.getBlockID()).setChunkData(write.getChunkData()).setStage(ContainerProtos.Stage.COMMIT_DATA).build();
            ContainerProtos.ContainerCommandRequestProto commitContainerCommandProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)proto).setWriteChunk(commitWriteChunkProto).build();
            log = RaftProtos.SMLogEntryProto.newBuilder().setData(commitContainerCommandProto.toByteString()).setStateMachineData(dataContainerCommandProto.toByteString()).build();
        } else {
            log = proto.getCmdType() == ContainerProtos.Type.CreateContainer ? RaftProtos.SMLogEntryProto.newBuilder().setData(request.getMessage().getContent()).setStateMachineData(request.getMessage().getContent()).build() : RaftProtos.SMLogEntryProto.newBuilder().setData(request.getMessage().getContent()).build();
        }
        return new TransactionContextImpl((StateMachine)this, request, log);
    }

    private ContainerProtos.ContainerCommandRequestProto getRequestProto(ByteString request) throws InvalidProtocolBufferException {
        return ContainerProtos.ContainerCommandRequestProto.parseFrom((ByteString)request);
    }

    private ContainerProtos.ContainerCommandResponseProto dispatchCommand(ContainerProtos.ContainerCommandRequestProto requestProto) {
        LOG.trace("dispatch {}", (Object)requestProto);
        ContainerProtos.ContainerCommandResponseProto response = this.dispatcher.dispatch(requestProto);
        LOG.trace("response {}", (Object)response);
        return response;
    }

    private Message runCommand(ContainerProtos.ContainerCommandRequestProto requestProto) {
        return () -> ((ContainerProtos.ContainerCommandResponseProto)this.dispatchCommand(requestProto)).toByteString();
    }

    public CompletableFuture<Message> writeStateMachineData(RaftProtos.LogEntryProto entry) {
        try {
            this.metrics.incNumWriteStateMachineOps();
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(entry.getSmLogEntry().getStateMachineData());
            ContainerProtos.Type cmdType = requestProto.getCmdType();
            long containerId = requestProto.getContainerID();
            this.stateMachineMap.computeIfAbsent(containerId, k -> new StateMachineHelper());
            CompletableFuture<Message> stateMachineFuture = this.stateMachineMap.get(containerId).handleStateMachineData(requestProto, entry.getIndex());
            if (stateMachineFuture == null) {
                throw new IllegalStateException("Cmd Type:" + cmdType + " should not have state machine data");
            }
            return stateMachineFuture;
        }
        catch (IOException e) {
            this.metrics.incNumWriteStateMachineFails();
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            this.metrics.incNumReadStateMachineOps();
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(request.getContent());
            return CompletableFuture.completedFuture(this.runCommand(requestProto));
        }
        catch (IOException e) {
            this.metrics.incNumReadStateMachineFails();
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    private RaftProtos.LogEntryProto readStateMachineData(RaftProtos.LogEntryProto entry, ContainerProtos.ContainerCommandRequestProto requestProto) {
        ContainerProtos.WriteChunkRequestProto writeChunkRequestProto = requestProto.getWriteChunk();
        Preconditions.checkArgument((writeChunkRequestProto.getStage() == ContainerProtos.Stage.COMMIT_DATA ? 1 : 0) != 0);
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequestProto = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(writeChunkRequestProto.getBlockID()).setChunkData(writeChunkRequestProto.getChunkData());
        ContainerProtos.ContainerCommandRequestProto dataContainerCommandProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)requestProto).setCmdType(ContainerProtos.Type.ReadChunk).setReadChunk(readChunkRequestProto).build();
        ContainerProtos.ContainerCommandResponseProto response = this.dispatchCommand(dataContainerCommandProto);
        ContainerProtos.ReadChunkResponseProto responseProto = response.getReadChunk();
        Preconditions.checkNotNull((Object)responseProto.getData());
        ContainerProtos.WriteChunkRequestProto.Builder dataWriteChunkProto = ContainerProtos.WriteChunkRequestProto.newBuilder((ContainerProtos.WriteChunkRequestProto)writeChunkRequestProto).setData(responseProto.getData()).setStage(ContainerProtos.Stage.WRITE_DATA);
        ContainerProtos.ContainerCommandRequestProto.Builder newStateMachineProto = ContainerProtos.ContainerCommandRequestProto.newBuilder((ContainerProtos.ContainerCommandRequestProto)requestProto).setWriteChunk(dataWriteChunkProto);
        return this.recreateLogEntryProto(entry, newStateMachineProto.build().toByteString());
    }

    private RaftProtos.LogEntryProto recreateLogEntryProto(RaftProtos.LogEntryProto entry, ByteString stateMachineData) {
        RaftProtos.SMLogEntryProto log = RaftProtos.SMLogEntryProto.newBuilder((RaftProtos.SMLogEntryProto)entry.getSmLogEntry()).setStateMachineData(stateMachineData).build();
        return RaftProtos.LogEntryProto.newBuilder((RaftProtos.LogEntryProto)entry).setSmLogEntry(log).build();
    }

    public CompletableFuture<Void> flushStateMachineData(long index) {
        List<CompletableFuture> futureList = this.writeChunkFutureMap.entrySet().stream().filter(x -> (Long)x.getKey() <= index).map(x -> (CompletableFuture)x.getValue()).collect(Collectors.toList());
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
        return combinedFuture;
    }

    public CompletableFuture<RaftProtos.LogEntryProto> readStateMachineData(RaftProtos.LogEntryProto entry) {
        RaftProtos.SMLogEntryProto smLogEntryProto = entry.getSmLogEntry();
        if (!smLogEntryProto.getStateMachineData().isEmpty()) {
            return CompletableFuture.completedFuture(entry);
        }
        try {
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(entry.getSmLogEntry().getData());
            Preconditions.checkArgument((!HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)requestProto) ? 1 : 0) != 0);
            if (requestProto.getCmdType() == ContainerProtos.Type.WriteChunk) {
                return CompletableFuture.supplyAsync(() -> this.readStateMachineData(entry, requestProto), this.chunkExecutor);
            }
            if (requestProto.getCmdType() == ContainerProtos.Type.CreateContainer) {
                RaftProtos.LogEntryProto log = this.recreateLogEntryProto(entry, requestProto.toByteString());
                return CompletableFuture.completedFuture(log);
            }
            throw new IllegalStateException("Cmd type:" + requestProto.getCmdType() + " cannot have state machine data");
        }
        catch (Exception e) {
            LOG.error("unable to read stateMachineData:" + e);
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        try {
            this.metrics.incNumApplyTransactionsOps();
            ContainerProtos.ContainerCommandRequestProto requestProto = this.getRequestProto(trx.getSMLogEntry().getData());
            Preconditions.checkState((!HddsUtils.isReadOnly((ContainerProtos.ContainerCommandRequestProto)requestProto) ? 1 : 0) != 0);
            this.stateMachineMap.computeIfAbsent(requestProto.getContainerID(), k -> new StateMachineHelper());
            long index = trx.getLogEntry() == null ? -1L : trx.getLogEntry().getIndex();
            return this.stateMachineMap.get(requestProto.getContainerID()).executeContainerCommand(requestProto, index);
        }
        catch (IOException e) {
            this.metrics.incNumApplyTransactionsFails();
            return ContainerStateMachine.completeExceptionally(e);
        }
    }

    private static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }

    public void notifySlowness(RaftGroup group, RaftProtos.RoleInfoProto roleInfoProto) {
        this.ratisServer.handleNodeSlowness(group, roleInfoProto);
    }

    public void notifyExtendedNoLeader(RaftGroup group, RaftProtos.RoleInfoProto roleInfoProto) {
        this.ratisServer.handleNoLeader(group, roleInfoProto);
    }

    public void close() throws IOException {
    }

    @VisibleForTesting
    public ConcurrentHashMap<Long, StateMachineHelper> getStateMachineMap() {
        return this.stateMachineMap;
    }

    @VisibleForTesting
    public CompletableFuture<Message> getCreateContainerFuture(long containerId) {
        StateMachineHelper helper = this.stateMachineMap.get(containerId);
        return helper == null ? null : helper.createContainerFuture;
    }

    @VisibleForTesting
    public List<CompletableFuture<Message>> getCommitChunkFutureMap(long containerId) {
        StateMachineHelper helper = this.stateMachineMap.get(containerId);
        if (helper != null) {
            ArrayList<CompletableFuture<Message>> futureList = new ArrayList<CompletableFuture<Message>>();
            this.stateMachineMap.get(containerId).block2ChunkMap.values().forEach(b -> futureList.addAll(b.getAll()));
            return futureList;
        }
        return null;
    }

    @VisibleForTesting
    public Collection<CompletableFuture<Message>> getWriteChunkFutureMap() {
        return this.writeChunkFutureMap.values();
    }

    private class StateMachineHelper {
        private CompletableFuture<Message> createContainerFuture = null;
        private final ConcurrentHashMap<Long, CommitChunkFutureMap> block2ChunkMap = new ConcurrentHashMap();
        private final ConcurrentHashMap<Long, CompletableFuture<Message>> blockCommitMap = new ConcurrentHashMap();

        StateMachineHelper() {
        }

        private CompletableFuture<Message> handleCreateContainer() {
            this.createContainerFuture = new CompletableFuture();
            return CompletableFuture.completedFuture(() -> ByteString.EMPTY);
        }

        private CompletableFuture<Message> handleWriteChunk(ContainerProtos.ContainerCommandRequestProto requestProto, long entryIndex) {
            CompletionStage<Object> containerOpFuture = this.createContainerFuture != null ? this.createContainerFuture.thenApplyAsync(v -> ContainerStateMachine.this.runCommand(requestProto), (Executor)ContainerStateMachine.this.chunkExecutor) : CompletableFuture.supplyAsync(() -> ContainerStateMachine.this.runCommand(requestProto), ContainerStateMachine.this.chunkExecutor);
            ContainerStateMachine.this.writeChunkFutureMap.put(entryIndex, containerOpFuture);
            return containerOpFuture;
        }

        CompletableFuture<Message> handleStateMachineData(ContainerProtos.ContainerCommandRequestProto requestProto, long index) {
            ContainerProtos.Type cmdType = requestProto.getCmdType();
            if (cmdType == ContainerProtos.Type.CreateContainer) {
                return this.handleCreateContainer();
            }
            if (cmdType == ContainerProtos.Type.WriteChunk) {
                return this.handleWriteChunk(requestProto, index);
            }
            return null;
        }

        private CompletableFuture<Message> handlePutKey(ContainerProtos.ContainerCommandRequestProto requestProto) {
            ArrayList<CompletableFuture<Message>> futureList = new ArrayList<CompletableFuture<Message>>();
            long localId = requestProto.getPutKey().getKeyData().getBlockID().getLocalID();
            if (this.block2ChunkMap.get(localId) != null) {
                futureList.addAll(this.block2ChunkMap.get(localId).getAll());
            }
            CompletableFuture<Message> effectiveFuture = this.runCommandAfterFutures(futureList, requestProto);
            CompletionStage putKeyFuture = effectiveFuture.thenApply(message -> {
                this.blockCommitMap.remove(localId);
                return message;
            });
            this.blockCommitMap.put(localId, (CompletableFuture<Message>)putKeyFuture);
            return putKeyFuture;
        }

        private CompletableFuture<Message> handleCloseContainer(ContainerProtos.ContainerCommandRequestProto requestProto) {
            ArrayList<CompletableFuture<Message>> futureList = new ArrayList<CompletableFuture<Message>>();
            this.block2ChunkMap.values().forEach(b -> futureList.addAll(b.getAll()));
            futureList.addAll(this.blockCommitMap.values());
            CompletableFuture<Message> closeContainerFuture = this.runCommandAfterFutures(futureList, requestProto);
            return closeContainerFuture.thenApply(message -> {
                ContainerStateMachine.this.stateMachineMap.remove(requestProto.getContainerID());
                return message;
            });
        }

        private CompletableFuture<Message> handleChunkCommit(ContainerProtos.ContainerCommandRequestProto requestProto, long index) {
            ContainerProtos.WriteChunkRequestProto write = requestProto.getWriteChunk();
            Preconditions.checkArgument((!write.hasData() ? 1 : 0) != 0);
            CompletableFuture stateMachineFuture = (CompletableFuture)ContainerStateMachine.this.writeChunkFutureMap.remove(index);
            CompletionStage commitChunkFuture = stateMachineFuture.thenComposeAsync(v -> CompletableFuture.completedFuture(ContainerStateMachine.this.runCommand(requestProto)));
            long localId = requestProto.getWriteChunk().getBlockID().getLocalID();
            this.block2ChunkMap.computeIfAbsent(localId, id -> new CommitChunkFutureMap()).add(index, (CompletableFuture<Message>)commitChunkFuture);
            return ((CompletableFuture)commitChunkFuture).thenApply(message -> {
                this.block2ChunkMap.computeIfPresent(localId, (containerId, chunks) -> chunks.removeAndGetSize(index) == 0 ? null : chunks);
                return message;
            });
        }

        private CompletableFuture<Message> runCommandAfterFutures(List<CompletableFuture<Message>> futureList, ContainerProtos.ContainerCommandRequestProto requestProto) {
            CompletionStage<Object> effectiveFuture;
            if (futureList.isEmpty()) {
                effectiveFuture = CompletableFuture.supplyAsync(() -> ContainerStateMachine.this.runCommand(requestProto));
            } else {
                CompletableFuture<Void> allFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
                effectiveFuture = allFuture.thenApplyAsync(v -> ContainerStateMachine.this.runCommand(requestProto));
            }
            return effectiveFuture;
        }

        CompletableFuture<Message> handleCreateContainer(ContainerProtos.ContainerCommandRequestProto requestProto) {
            CompletableFuture<Message> future = CompletableFuture.completedFuture(ContainerStateMachine.this.runCommand(requestProto));
            future.thenAccept(m -> {
                this.createContainerFuture.complete((Message)m);
                this.createContainerFuture = null;
            });
            return future;
        }

        CompletableFuture<Message> handleOtherCommands(ContainerProtos.ContainerCommandRequestProto requestProto) {
            return CompletableFuture.completedFuture(ContainerStateMachine.this.runCommand(requestProto));
        }

        CompletableFuture<Message> executeContainerCommand(ContainerProtos.ContainerCommandRequestProto requestProto, long index) {
            ContainerProtos.Type cmdType = requestProto.getCmdType();
            switch (cmdType) {
                case WriteChunk: {
                    return this.handleChunkCommit(requestProto, index);
                }
                case CloseContainer: {
                    return this.handleCloseContainer(requestProto);
                }
                case PutKey: {
                    return this.handlePutKey(requestProto);
                }
                case CreateContainer: {
                    return this.handleCreateContainer(requestProto);
                }
            }
            return this.handleOtherCommands(requestProto);
        }
    }

    static class CommitChunkFutureMap {
        private final ConcurrentHashMap<Long, CompletableFuture<Message>> block2ChunkMap = new ConcurrentHashMap();

        CommitChunkFutureMap() {
        }

        synchronized int removeAndGetSize(long index) {
            this.block2ChunkMap.remove(index);
            return this.block2ChunkMap.size();
        }

        synchronized CompletableFuture<Message> add(long index, CompletableFuture<Message> future) {
            return this.block2ChunkMap.put(index, future);
        }

        synchronized List<CompletableFuture<Message>> getAll() {
            return new ArrayList<CompletableFuture<Message>>(this.block2ChunkMap.values());
        }
    }
}

