/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.PipelineID;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.transport.server.GrpcXceiverService;
import org.apache.hadoop.ozone.container.common.transport.server.XceiverServerSpi;
import org.apache.ratis.shaded.io.grpc.BindableService;
import org.apache.ratis.shaded.io.grpc.Server;
import org.apache.ratis.shaded.io.grpc.ServerBuilder;
import org.apache.ratis.shaded.io.grpc.netty.NettyServerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XceiverServerGrpc
implements XceiverServerSpi {
    private static final Logger LOG = LoggerFactory.getLogger(XceiverServerGrpc.class);
    private int port;
    private UUID id;
    private Server server;
    private final ContainerDispatcher storageContainer;

    public XceiverServerGrpc(DatanodeDetails datanodeDetails, Configuration conf, ContainerDispatcher dispatcher, BindableService ... additionalServices) {
        Preconditions.checkNotNull((Object)conf);
        this.id = datanodeDetails.getUuid();
        this.port = conf.getInt("dfs.container.ipc", 9859);
        if (conf.getBoolean("dfs.container.ipc.random.port", false)) {
            try {
                BindableService[] bindableServiceArray = null;
                try (ServerSocket socket = new ServerSocket();){
                    socket.setReuseAddress(true);
                    InetSocketAddress address = new InetSocketAddress(0);
                    socket.bind(address);
                    this.port = socket.getLocalPort();
                    LOG.info("Found a free port for the server : {}", (Object)this.port);
                }
                catch (Throwable object) {
                    bindableServiceArray = object;
                    throw object;
                }
            }
            catch (IOException e) {
                LOG.error("Unable find a random free port for the server, fallback to use default port {}", (Object)this.port, (Object)e);
            }
        }
        datanodeDetails.setPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)this.port));
        this.server = ((NettyServerBuilder)((NettyServerBuilder)ServerBuilder.forPort((int)this.port)).maxInboundMessageSize(0x2000000).addService((BindableService)new GrpcXceiverService(dispatcher))).build();
        NettyServerBuilder nettyServerBuilder = (NettyServerBuilder)((NettyServerBuilder)ServerBuilder.forPort((int)this.port)).maxInboundMessageSize(0x2000000).addService((BindableService)new GrpcXceiverService(dispatcher));
        for (BindableService service : additionalServices) {
            nettyServerBuilder.addService(service);
        }
        this.server = nettyServerBuilder.build();
        this.storageContainer = dispatcher;
    }

    @Override
    public int getIPCPort() {
        return this.port;
    }

    @Override
    public HddsProtos.ReplicationType getServerType() {
        return HddsProtos.ReplicationType.STAND_ALONE;
    }

    @Override
    public void start() throws IOException {
        this.server.start();
    }

    @Override
    public void stop() {
        this.server.shutdown();
    }

    @Override
    public void submitRequest(ContainerProtos.ContainerCommandRequestProto request, HddsProtos.PipelineID pipelineID) throws IOException {
        ContainerProtos.ContainerCommandResponseProto response = this.storageContainer.dispatch(request);
        if (response.getResult() != ContainerProtos.Result.SUCCESS) {
            throw new StorageContainerException(response.getMessage(), response.getResult());
        }
    }

    @Override
    public List<StorageContainerDatanodeProtocolProtos.PipelineReport> getPipelineReport() {
        return Collections.singletonList(StorageContainerDatanodeProtocolProtos.PipelineReport.newBuilder().setPipelineID(PipelineID.valueOf((UUID)this.id).getProtobuf()).build());
    }
}

