/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    static final Logger LOG = LoggerFactory.getLogger(RegisterEndpointTask.class);
    private final EndpointStateMachine rpcEndPoint;
    private final Configuration conf;
    private Future<EndpointStateMachine.EndPointStates> result;
    private DatanodeDetails datanodeDetails;
    private final OzoneContainer datanodeContainerManager;
    private StateContext stateContext;

    @VisibleForTesting
    public RegisterEndpointTask(EndpointStateMachine rpcEndPoint, Configuration conf, OzoneContainer ozoneContainer, StateContext context) {
        this.rpcEndPoint = rpcEndPoint;
        this.conf = conf;
        this.datanodeContainerManager = ozoneContainer;
        this.stateContext = context;
    }

    public DatanodeDetails getDatanodeDetails() {
        return this.datanodeDetails;
    }

    public void setDatanodeDetails(DatanodeDetails datanodeDetails) {
        this.datanodeDetails = datanodeDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        if (this.getDatanodeDetails() == null) {
            LOG.error("DatanodeDetails cannot be null in RegisterEndpoint task, shutting down the endpoint.");
            return this.rpcEndPoint.setState(EndpointStateMachine.EndPointStates.SHUTDOWN);
        }
        this.rpcEndPoint.lock();
        try {
            StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = this.datanodeContainerManager.getContainerReport();
            StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = this.datanodeContainerManager.getNodeReport();
            StorageContainerDatanodeProtocolProtos.PipelineReportsProto pipelineReportsProto = this.datanodeContainerManager.getPipelineReport();
            StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto response = this.rpcEndPoint.getEndPoint().register(this.datanodeDetails.getProtoBufMessage(), nodeReport, containerReport, pipelineReportsProto);
            Preconditions.checkState((boolean)UUID.fromString(response.getDatanodeUUID()).equals(this.datanodeDetails.getUuid()), (Object)"Unexpected datanode ID in the response.");
            Preconditions.checkState((!StringUtils.isBlank((CharSequence)response.getClusterID()) ? 1 : 0) != 0, (Object)"Invalid cluster ID in the response.");
            if (response.hasHostname() && response.hasIpAddress()) {
                this.datanodeDetails.setHostName(response.getHostname());
                this.datanodeDetails.setIpAddress(response.getIpAddress());
            }
            EndpointStateMachine.EndPointStates nextState = this.rpcEndPoint.getState().getNextState();
            this.rpcEndPoint.setState(nextState);
            this.rpcEndPoint.zeroMissedCount();
            this.stateContext.configureHeartbeatFrequency();
        }
        catch (IOException ex) {
            this.rpcEndPoint.logIfNeeded(ex);
        }
        finally {
            this.rpcEndPoint.unlock();
        }
        return this.rpcEndPoint.getState();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private EndpointStateMachine endPointStateMachine;
        private Configuration conf;
        private DatanodeDetails datanodeDetails;
        private OzoneContainer container;
        private StateContext context;

        public Builder setEndpointStateMachine(EndpointStateMachine rpcEndPoint) {
            this.endPointStateMachine = rpcEndPoint;
            return this;
        }

        public Builder setConfig(Configuration config) {
            this.conf = config;
            return this;
        }

        public Builder setDatanodeDetails(DatanodeDetails dnDetails) {
            this.datanodeDetails = dnDetails;
            return this;
        }

        public Builder setOzoneContainer(OzoneContainer ozoneContainer) {
            this.container = ozoneContainer;
            return this;
        }

        public Builder setContext(StateContext stateContext) {
            this.context = stateContext;
            return this;
        }

        public RegisterEndpointTask build() {
            if (this.endPointStateMachine == null) {
                LOG.error("No endpoint specified.");
                throw new IllegalArgumentException("A valid endpoint state machine is needed to construct RegisterEndPoint task");
            }
            if (this.conf == null) {
                LOG.error("No config specified.");
                throw new IllegalArgumentException("A valid configuration is needed to construct RegisterEndpoint task");
            }
            if (this.datanodeDetails == null) {
                LOG.error("No datanode specified.");
                throw new IllegalArgumentException("A vaild Node ID is needed to construct RegisterEndpoint task");
            }
            if (this.container == null) {
                LOG.error("Container is not specified");
                throw new IllegalArgumentException("Container is not specified to construct RegisterEndpoint task");
            }
            if (this.context == null) {
                LOG.error("StateContext is not specified");
                throw new IllegalArgumentException("Container is not specified to construct RegisterEndpoint task");
            }
            RegisterEndpointTask task = new RegisterEndpointTask(this.endPointStateMachine, this.conf, this.container, this.context);
            task.setDatanodeDetails(this.datanodeDetails);
            return task;
        }
    }
}

