/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.helpers.DeletedContainerBlocksSummary;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    static final Logger LOG = LoggerFactory.getLogger(HeartbeatEndpointTask.class);
    private final EndpointStateMachine rpcEndpoint;
    private final Configuration conf;
    private HddsProtos.DatanodeDetailsProto datanodeDetailsProto;
    private StateContext context;
    private int maxContainerActionsPerHB;
    private int maxPipelineActionsPerHB;

    public HeartbeatEndpointTask(EndpointStateMachine rpcEndpoint, Configuration conf, StateContext context) {
        this.rpcEndpoint = rpcEndpoint;
        this.conf = conf;
        this.context = context;
        this.maxContainerActionsPerHB = conf.getInt("hdds.container.action.max.limit", 20);
        this.maxPipelineActionsPerHB = conf.getInt("hdds.pipeline.action.max.limit", 20);
    }

    public HddsProtos.DatanodeDetailsProto getDatanodeDetailsProto() {
        return this.datanodeDetailsProto;
    }

    public void setDatanodeDetailsProto(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        this.datanodeDetailsProto = datanodeDetailsProto;
    }

    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        this.rpcEndpoint.lock();
        try {
            Preconditions.checkState((this.datanodeDetailsProto != null ? 1 : 0) != 0);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(this.datanodeDetailsProto);
            this.addReports(requestBuilder);
            this.addContainerActions(requestBuilder);
            this.addPipelineActions(requestBuilder);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto reponse = this.rpcEndpoint.getEndPoint().sendHeartbeat(requestBuilder.build());
            this.processResponse(reponse, this.datanodeDetailsProto);
            this.rpcEndpoint.setLastSuccessfulHeartbeat(ZonedDateTime.now());
            this.rpcEndpoint.zeroMissedCount();
        }
        catch (IOException ex) {
            this.rpcEndpoint.logIfNeeded(ex);
        }
        finally {
            this.rpcEndpoint.unlock();
        }
        return this.rpcEndpoint.getState();
    }

    private void addReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        for (GeneratedMessage report : this.context.getAllAvailableReports()) {
            String reportName = report.getDescriptorForType().getFullName();
            for (Descriptors.FieldDescriptor descriptor : StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.getDescriptor().getFields()) {
                String heartbeatFieldName = descriptor.getMessageType().getFullName();
                if (!heartbeatFieldName.equals(reportName)) continue;
                requestBuilder.setField(descriptor, report);
            }
        }
    }

    private void addContainerActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.context.getPendingContainerAction(this.maxContainerActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.ContainerActionsProto cap = StorageContainerDatanodeProtocolProtos.ContainerActionsProto.newBuilder().addAllContainerActions(actions).build();
            requestBuilder.setContainerActions(cap);
        }
    }

    private void addPipelineActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.PipelineAction> actions = this.context.getPendingPipelineAction(this.maxPipelineActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.PipelineActionsProto pap = StorageContainerDatanodeProtocolProtos.PipelineActionsProto.newBuilder().addAllPipelineActions(actions).build();
            requestBuilder.setPipelineActions(pap);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void processResponse(StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response, HddsProtos.DatanodeDetailsProto datanodeDetails) {
        Preconditions.checkState((boolean)response.getDatanodeUUID().equalsIgnoreCase(datanodeDetails.getUuid()), (Object)"Unexpected datanode ID in the response.");
        block6: for (StorageContainerDatanodeProtocolProtos.SCMCommandProto commandResponseProto : response.getCommandsList()) {
            switch (commandResponseProto.getCommandType()) {
                case reregisterCommand: {
                    if (this.rpcEndpoint.getState() == EndpointStateMachine.EndPointStates.HEARTBEAT) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Received SCM notification to register. Interrupt HEARTBEAT and transit to REGISTER state.");
                        }
                        this.rpcEndpoint.setState(EndpointStateMachine.EndPointStates.REGISTER);
                        continue block6;
                    }
                    if (!LOG.isDebugEnabled()) continue block6;
                    LOG.debug("Illegal state {} found, expecting {}.", (Object)this.rpcEndpoint.getState().name(), (Object)EndpointStateMachine.EndPointStates.HEARTBEAT);
                    continue block6;
                }
                case deleteBlocksCommand: {
                    DeleteBlocksCommand db = DeleteBlocksCommand.getFromProtobuf(commandResponseProto.getDeleteBlocksCommandProto());
                    if (db.blocksTobeDeleted().isEmpty()) continue block6;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(DeletedContainerBlocksSummary.getFrom(db.blocksTobeDeleted()).toString());
                    }
                    this.context.addCommand(db);
                    continue block6;
                }
                case closeContainerCommand: {
                    CloseContainerCommand closeContainer = CloseContainerCommand.getFromProtobuf(commandResponseProto.getCloseContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container close request for container {}", (Object)closeContainer.getContainerID());
                    }
                    this.context.addCommand(closeContainer);
                    continue block6;
                }
                case replicateContainerCommand: {
                    ReplicateContainerCommand replicateContainerCommand = ReplicateContainerCommand.getFromProtobuf(commandResponseProto.getReplicateContainerCommandProto());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container replicate request for container {}", (Object)replicateContainerCommand.getContainerID());
                    }
                    this.context.addCommand(replicateContainerCommand);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown response : " + commandResponseProto.getCommandType().name());
        }
    }

    public static class Builder {
        private EndpointStateMachine endPointStateMachine;
        private Configuration conf;
        private DatanodeDetails datanodeDetails;
        private StateContext context;

        public Builder setEndpointStateMachine(EndpointStateMachine rpcEndPoint) {
            this.endPointStateMachine = rpcEndPoint;
            return this;
        }

        public Builder setConfig(Configuration config) {
            this.conf = config;
            return this;
        }

        public Builder setDatanodeDetails(DatanodeDetails dnDetails) {
            this.datanodeDetails = dnDetails;
            return this;
        }

        public Builder setContext(StateContext stateContext) {
            this.context = stateContext;
            return this;
        }

        public HeartbeatEndpointTask build() {
            if (this.endPointStateMachine == null) {
                LOG.error("No endpoint specified.");
                throw new IllegalArgumentException("A valid endpoint state machine is needed to construct HeartbeatEndpointTask task");
            }
            if (this.conf == null) {
                LOG.error("No config specified.");
                throw new IllegalArgumentException("A valid configration is needed to construct HeartbeatEndpointTask task");
            }
            if (this.datanodeDetails == null) {
                LOG.error("No datanode specified.");
                throw new IllegalArgumentException("A vaild Node ID is needed to construct HeartbeatEndpointTask task");
            }
            HeartbeatEndpointTask task = new HeartbeatEndpointTask(this.endPointStateMachine, this.conf, this.context);
            task.setDatanodeDetailsProto(this.datanodeDetails.getProtoBufMessage());
            return task;
        }
    }
}

