/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.container.replication.ReplicationSupervisor;
import org.apache.hadoop.ozone.container.replication.ReplicationTask;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicateContainerCommandHandler
implements CommandHandler {
    static final Logger LOG = LoggerFactory.getLogger(ReplicateContainerCommandHandler.class);
    private int invocationCount;
    private long totalTime;
    private Configuration conf;
    private ReplicationSupervisor supervisor;

    public ReplicateContainerCommandHandler(Configuration conf, ReplicationSupervisor supervisor) {
        this.conf = conf;
        this.supervisor = supervisor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        ReplicateContainerCommand replicateCommand = (ReplicateContainerCommand)command;
        try {
            List<DatanodeDetails> sourceDatanodes = replicateCommand.getSourceDatanodes();
            long containerID = replicateCommand.getContainerID();
            Preconditions.checkArgument((sourceDatanodes.size() > 0 ? 1 : 0) != 0, (Object)String.format("Replication command is received for container %d but the size of source datanodes was 0.", containerID));
            ReplicationTask replicationTask = new ReplicationTask(containerID, sourceDatanodes);
            this.supervisor.addTask(replicationTask);
        }
        finally {
            this.updateCommandStatus(context, command, true, LOG);
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount > 0) {
            return this.totalTime / (long)this.invocationCount;
        }
        return 0L;
    }
}

