/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.ozone.container.common.helpers.DeletedContainerBlocksSummary;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyUtils;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BatchOperation;
import org.apache.hadoop.utils.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBlocksCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteBlocksCommandHandler.class);
    private final ContainerSet containerSet;
    private final Configuration conf;
    private int invocationCount;
    private long totalTime;
    private boolean cmdExecuted;

    public DeleteBlocksCommandHandler(ContainerSet cset, Configuration conf) {
        this.containerSet = cset;
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        this.cmdExecuted = false;
        long startTime = Time.monotonicNow();
        try {
            if (command.getType() != StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) {
                LOG.warn("Skipping handling command, expected command type {} but found {}", (Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand, (Object)command.getType());
                return;
            }
            LOG.debug("Processing block deletion command.");
            ++this.invocationCount;
            DeleteBlocksCommand cmd = (DeleteBlocksCommand)command;
            List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> containerBlocks = cmd.blocksTobeDeleted();
            DeletedContainerBlocksSummary summary = DeletedContainerBlocksSummary.getFrom(containerBlocks);
            LOG.info("Start to delete container blocks, TXIDs={}, numOfContainers={}, numOfBlocks={}", new Object[]{summary.getTxIDSummary(), summary.getNumOfContainers(), summary.getNumOfBlocks()});
            StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.Builder resultBuilder = StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.newBuilder();
            containerBlocks.forEach(entry -> {
                StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult.Builder txResultBuilder = StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult.newBuilder();
                txResultBuilder.setTxID(entry.getTxID());
                long containerId = entry.getContainerID();
                try {
                    Container cont = this.containerSet.getContainer(containerId);
                    if (cont == null) {
                        throw new StorageContainerException("Unable to find the container " + containerId, ContainerProtos.Result.CONTAINER_NOT_FOUND);
                    }
                    ContainerProtos.ContainerType containerType = cont.getContainerType();
                    switch (containerType) {
                        case KeyValueContainer: {
                            KeyValueContainerData containerData = (KeyValueContainerData)cont.getContainerData();
                            this.deleteKeyValueContainerBlocks(containerData, (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)entry);
                            txResultBuilder.setContainerID(containerId).setSuccess(true);
                            break;
                        }
                        default: {
                            LOG.error("Delete Blocks Command Handler is not implemented for containerType {}", (Object)containerType);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete blocks for container={}, TXID={}", new Object[]{entry.getContainerID(), entry.getTxID(), e});
                    txResultBuilder.setContainerID(containerId).setSuccess(false);
                }
                resultBuilder.addResults(txResultBuilder.build()).setDnId(context.getParent().getDatanodeDetails().getUuid().toString());
            });
            StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto blockDeletionACK = resultBuilder.build();
            if (!containerBlocks.isEmpty()) {
                for (EndpointStateMachine endPoint : connectionManager.getValues()) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending following block deletion ACK to SCM");
                            for (StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult result : blockDeletionACK.getResultsList()) {
                                LOG.debug(result.getTxID() + " : " + result.getSuccess());
                            }
                        }
                        endPoint.getEndPoint().sendContainerBlocksDeletionACK(blockDeletionACK);
                    }
                    catch (IOException e) {
                        LOG.error("Unable to send block deletion ACK to SCM {}", (Object)endPoint.getAddress().toString(), (Object)e);
                    }
                }
            }
            this.cmdExecuted = true;
        }
        finally {
            this.updateCommandStatus(context, command, this.cmdExecuted, LOG);
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
        }
    }

    private void deleteKeyValueContainerBlocks(KeyValueContainerData containerData, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX) throws IOException {
        long containerId = delTX.getContainerID();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing Container : {}, DB path : {}", (Object)containerId, (Object)containerData.getMetadataPath());
        }
        if (delTX.getTxID() < containerData.getDeleteTransactionId()) {
            LOG.debug(String.format("Ignoring delete blocks for containerId: %d. Outdated delete transactionId %d < %d", containerId, delTX.getTxID(), containerData.getDeleteTransactionId()));
            return;
        }
        int newDeletionBlocks = 0;
        MetadataStore containerDB = KeyUtils.getDB(containerData, this.conf);
        for (Long blk : delTX.getLocalIDList()) {
            BatchOperation batch = new BatchOperation();
            byte[] blkBytes = Longs.toByteArray((long)blk);
            byte[] blkInfo = containerDB.get(blkBytes);
            if (blkInfo != null) {
                byte[] deletingKeyBytes = DFSUtil.string2Bytes((String)("#deleting#" + blk));
                byte[] deletedKeyBytes = DFSUtil.string2Bytes((String)("#deleted#" + blk));
                if (containerDB.get(deletingKeyBytes) != null || containerDB.get(deletedKeyBytes) != null) {
                    LOG.debug(String.format("Ignoring delete for block %d in container %d. Entry already added.", blk, containerId));
                    continue;
                }
                batch.put(deletingKeyBytes, blkInfo);
                batch.delete(blkBytes);
                try {
                    containerDB.writeBatch(batch);
                    ++newDeletionBlocks;
                    LOG.debug("Transited Block {} to DELETING state in container {}", (Object)blk, (Object)containerId);
                    continue;
                }
                catch (IOException e) {
                    throw new IOException("Failed to delete blocks for TXID = " + delTX.getTxID(), e);
                }
            }
            LOG.debug("Block {} not found or already under deletion in container {}, skip deleting it.", (Object)blk, (Object)containerId);
        }
        containerDB.put(DFSUtil.string2Bytes((String)("#delTX#" + delTX.getContainerID())), Longs.toByteArray((long)delTX.getTxID()));
        containerData.updateDeleteTransactionId(delTX.getTxID());
        containerData.incrPendingDeletionBlocks(newDeletionBlocks);
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount > 0) {
            return this.totalTime / (long)this.invocationCount;
        }
        return 0L;
    }
}

