/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;
import org.apache.hadoop.ozone.container.common.report.ReportPublisherFactory;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.util.concurrent.HadoopExecutors;

public final class ReportManager {
    private final StateContext context;
    private final List<ReportPublisher> publishers;
    private final ScheduledExecutorService executorService;

    private ReportManager(StateContext context, List<ReportPublisher> publishers) {
        this.context = context;
        this.publishers = publishers;
        this.executorService = HadoopExecutors.newScheduledThreadPool((int)publishers.size(), (ThreadFactory)new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Datanode ReportManager Thread - %d").build());
    }

    public void init() {
        for (ReportPublisher publisher : this.publishers) {
            publisher.init(this.context, this.executorService);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public static Builder newBuilder(Configuration conf) {
        return new Builder(conf);
    }

    public static final class Builder {
        private StateContext stateContext;
        private List<ReportPublisher> reportPublishers = new ArrayList<ReportPublisher>();
        private ReportPublisherFactory publisherFactory;

        private Builder(Configuration conf) {
            this.publisherFactory = new ReportPublisherFactory(conf);
        }

        public Builder setStateContext(StateContext context) {
            this.stateContext = context;
            return this;
        }

        public Builder addPublisherFor(Class<? extends GeneratedMessage> report) {
            this.reportPublishers.add(this.publisherFactory.getPublisherFor(report));
            return this;
        }

        public Builder addPublisher(ReportPublisher publisher) {
            this.reportPublishers.add(publisher);
            return this;
        }

        public ReportManager build() {
            Preconditions.checkNotNull((Object)this.stateContext);
            return new ReportManager(this.stateContext, this.reportPublishers);
        }
    }
}

