/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;

public class PipelineReportPublisher
extends ReportPublisher<StorageContainerDatanodeProtocolProtos.PipelineReportsProto> {
    private Long pipelineReportInterval = null;

    @Override
    protected long getReportFrequency() {
        if (this.pipelineReportInterval == null) {
            this.pipelineReportInterval = this.getConf().getTimeDuration("hdds.pipeline.report.interval", "60s", TimeUnit.MILLISECONDS);
            long heartbeatFrequency = HddsServerUtil.getScmHeartbeatInterval(this.getConf());
            Preconditions.checkState((heartbeatFrequency <= this.pipelineReportInterval ? 1 : 0) != 0, (Object)"hdds.pipeline.report.interval cannot be configured lower than heartbeat frequency.");
        }
        return this.pipelineReportInterval + this.getRandomReportDelay();
    }

    private long getRandomReportDelay() {
        return RandomUtils.nextLong((long)0L, (long)this.pipelineReportInterval);
    }

    @Override
    protected StorageContainerDatanodeProtocolProtos.PipelineReportsProto getReport() {
        return this.getContext().getParent().getContainer().getPipelineReport();
    }
}

