/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;

public class ContainerReportPublisher
extends ReportPublisher<StorageContainerDatanodeProtocolProtos.ContainerReportsProto> {
    private Long containerReportInterval = null;

    @Override
    protected long getReportFrequency() {
        if (this.containerReportInterval == null) {
            this.containerReportInterval = this.getConf().getTimeDuration("hdds.container.report.interval", "60s", TimeUnit.MILLISECONDS);
            long heartbeatFrequency = HddsServerUtil.getScmHeartbeatInterval(this.getConf());
            Preconditions.checkState((heartbeatFrequency <= this.containerReportInterval ? 1 : 0) != 0, (Object)"hdds.container.report.interval cannot be configured lower than heartbeat frequency.");
        }
        return this.containerReportInterval + this.getRandomReportDelay();
    }

    private long getRandomReportDelay() {
        return RandomUtils.nextLong((long)0L, (long)this.containerReportInterval);
    }

    @Override
    protected StorageContainerDatanodeProtocolProtos.ContainerReportsProto getReport() throws IOException {
        return this.getContext().getParent().getContainer().getContainerReport();
    }
}

