/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSet {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerSet.class);
    private final ConcurrentSkipListMap<Long, Container> containerMap = new ConcurrentSkipListMap();

    public boolean addContainer(Container container) throws StorageContainerException {
        Preconditions.checkNotNull((Object)container, (Object)"container cannot be null");
        long containerId = ((ContainerData)container.getContainerData()).getContainerID();
        if (this.containerMap.putIfAbsent(containerId, container) == null) {
            LOG.debug("Container with container Id {} is added to containerMap", (Object)containerId);
            return true;
        }
        LOG.warn("Container already exists with container Id {}", (Object)containerId);
        throw new StorageContainerException("Container already exists with container Id " + containerId, ContainerProtos.Result.CONTAINER_EXISTS);
    }

    public Container getContainer(long containerId) {
        Preconditions.checkState((containerId >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative.");
        return this.containerMap.get(containerId);
    }

    public boolean removeContainer(long containerId) {
        Preconditions.checkState((containerId >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative.");
        Container removed = this.containerMap.remove(containerId);
        if (removed == null) {
            LOG.debug("Container with containerId {} is not present in containerMap", (Object)containerId);
            return false;
        }
        LOG.debug("Container with containerId {} is removed from containerMap", (Object)containerId);
        return true;
    }

    @VisibleForTesting
    public int containerCount() {
        return this.containerMap.size();
    }

    public Iterator<Container> getContainerIterator() {
        return this.containerMap.values().iterator();
    }

    public Iterator<Map.Entry<Long, Container>> getContainerMapIterator() {
        return this.containerMap.entrySet().iterator();
    }

    public Map<Long, Container> getContainerMap() {
        return ImmutableMap.copyOf(this.containerMap);
    }

    public void listContainer(long startContainerId, long count, List<ContainerData> data) throws StorageContainerException {
        Preconditions.checkNotNull(data, (Object)"Internal assertion: data cannot be null");
        Preconditions.checkState((startContainerId >= 0L ? 1 : 0) != 0, (Object)"Start container Id cannot be negative");
        Preconditions.checkState((count > 0L ? 1 : 0) != 0, (Object)"max number of containers returned must be positive");
        LOG.debug("listContainer returns containerData starting from {} of count {}", (Object)startContainerId, (Object)count);
        NavigableMap map = startContainerId == 0L ? this.containerMap.tailMap((Object)this.containerMap.firstKey(), true) : this.containerMap.tailMap((Object)startContainerId, true);
        int currentCount = 0;
        for (Container entry : map.values()) {
            if ((long)currentCount < count) {
                data.add((ContainerData)entry.getContainerData());
                ++currentCount;
                continue;
            }
            return;
        }
    }

    public StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReport() throws IOException {
        LOG.debug("Starting container report iteration.");
        List containers = this.containerMap.values().stream().collect(Collectors.toList());
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder crBuilder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
        for (Container container : containers) {
            crBuilder.addReports(container.getContainerReport());
        }
        return crBuilder.build();
    }

    public List<ContainerData> chooseContainerForBlockDeletion(int count, ContainerDeletionChoosingPolicy deletionPolicy) throws StorageContainerException {
        Map<Long, ContainerData> containerDataMap = this.containerMap.entrySet().stream().filter(e -> deletionPolicy.isValidContainerType(((Container)e.getValue()).getContainerType())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Container)e.getValue()).getContainerData()));
        return deletionPolicy.chooseContainerForBlockDeletion(count, containerDataMap);
    }
}

