/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.yaml.snakeyaml.Yaml;

public abstract class ContainerData {
    private final ContainerProtos.ContainerType containerType;
    private final long containerID;
    private final int layOutVersion;
    private final Map<String, String> metadata;
    private ContainerProtos.ContainerLifeCycleState state;
    private final long maxSize;
    private final AtomicLong readBytes;
    private final AtomicLong writeBytes;
    private final AtomicLong readCount;
    private final AtomicLong writeCount;
    private final AtomicLong bytesUsed;
    private final AtomicLong keyCount;
    private HddsVolume volume;
    private String checksum;
    public static final Charset CHARSET_ENCODING = Charset.forName("UTF-8");
    private static final String DUMMY_CHECKSUM = new String(new byte[64], CHARSET_ENCODING);
    protected static final List<String> YAML_FIELDS = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"containerType", "containerID", "layOutVersion", "state", "metadata", "maxSize", "checksum"}));

    protected ContainerData(ContainerProtos.ContainerType type, long containerId, long size) {
        this(type, containerId, ChunkLayOutVersion.getLatestVersion().getVersion(), size);
    }

    protected ContainerData(ContainerProtos.ContainerType type, long containerId, int layOutVersion, long size) {
        Preconditions.checkNotNull((Object)type);
        this.containerType = type;
        this.containerID = containerId;
        this.layOutVersion = layOutVersion;
        this.metadata = new TreeMap<String, String>();
        this.state = ContainerProtos.ContainerLifeCycleState.OPEN;
        this.readCount = new AtomicLong(0L);
        this.readBytes = new AtomicLong(0L);
        this.writeCount = new AtomicLong(0L);
        this.writeBytes = new AtomicLong(0L);
        this.bytesUsed = new AtomicLong(0L);
        this.keyCount = new AtomicLong(0L);
        this.maxSize = size;
        this.setChecksumTo0ByteArray();
    }

    public long getContainerID() {
        return this.containerID;
    }

    public abstract String getContainerPath();

    public ContainerProtos.ContainerType getContainerType() {
        return this.containerType;
    }

    public synchronized ContainerProtos.ContainerLifeCycleState getState() {
        return this.state;
    }

    public synchronized void setState(ContainerProtos.ContainerLifeCycleState state) {
        this.state = state;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public int getLayOutVersion() {
        return ChunkLayOutVersion.getChunkLayOutVersion(this.layOutVersion).getVersion();
    }

    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void setMetadata(Map<String, String> metadataMap) {
        this.metadata.clear();
        this.metadata.putAll(metadataMap);
    }

    public synchronized boolean isOpen() {
        return ContainerProtos.ContainerLifeCycleState.OPEN == this.state;
    }

    public synchronized boolean isValid() {
        return ContainerProtos.ContainerLifeCycleState.INVALID != this.state;
    }

    public synchronized boolean isClosed() {
        return ContainerProtos.ContainerLifeCycleState.CLOSED == this.state;
    }

    public synchronized void closeContainer() {
        this.setState(ContainerProtos.ContainerLifeCycleState.CLOSED);
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public void incrReadBytes(long bytes) {
        this.readBytes.addAndGet(bytes);
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public void incrReadCount() {
        this.readCount.incrementAndGet();
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    public void incrWriteBytes(long bytes) {
        this.writeBytes.addAndGet(bytes);
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public void incrWriteCount() {
        this.writeCount.incrementAndGet();
    }

    public void setBytesUsed(long used) {
        this.bytesUsed.set(used);
    }

    public long getBytesUsed() {
        return this.bytesUsed.get();
    }

    public long incrBytesUsed(long used) {
        return this.bytesUsed.addAndGet(used);
    }

    public long decrBytesUsed(long reclaimed) {
        return this.bytesUsed.addAndGet(-1L * reclaimed);
    }

    public void setVolume(HddsVolume hddsVolume) {
        this.volume = hddsVolume;
    }

    public HddsVolume getVolume() {
        return this.volume;
    }

    public void incrKeyCount() {
        this.keyCount.incrementAndGet();
    }

    public void decrKeyCount() {
        this.keyCount.decrementAndGet();
    }

    public long getKeyCount() {
        return this.keyCount.get();
    }

    public void setKeyCount(long count) {
        this.keyCount.set(count);
    }

    public void setChecksumTo0ByteArray() {
        this.checksum = DUMMY_CHECKSUM;
    }

    public void setChecksum(String checkSum) {
        this.checksum = checkSum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void computeAndSetChecksum(Yaml yaml) throws IOException {
        this.setChecksumTo0ByteArray();
        String containerDataYamlStr = yaml.dump((Object)this);
        this.checksum = ContainerUtils.getChecksum(containerDataYamlStr);
    }

    public abstract ContainerProtos.ContainerData getProtoBufMessage();
}

