/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.helpers.ContainerReport;

public class KeyValueContainerReport
extends ContainerReport {
    private long deleteTransactionId = 0L;

    public KeyValueContainerReport(long containerID, String finalhash) {
        super(containerID, finalhash);
    }

    public void updateDeleteTransactionId(long transactionId) {
        this.deleteTransactionId = Math.max(transactionId, this.deleteTransactionId);
    }

    public long getDeleteTransactionId() {
        return this.deleteTransactionId;
    }

    public static KeyValueContainerReport getFromProtoBuf(StorageContainerDatanodeProtocolProtos.ContainerInfo info) {
        Preconditions.checkNotNull((Object)info);
        KeyValueContainerReport report = new KeyValueContainerReport(info.getContainerID(), info.getFinalhash());
        if (info.hasSize()) {
            report.setSize(info.getSize());
        }
        if (info.hasKeyCount()) {
            report.setKeyCount(info.getKeyCount());
        }
        if (info.hasUsed()) {
            report.setBytesUsed(info.getUsed());
        }
        if (info.hasReadCount()) {
            report.setReadCount(info.getReadCount());
        }
        if (info.hasReadBytes()) {
            report.setReadBytes(info.getReadBytes());
        }
        if (info.hasWriteCount()) {
            report.setWriteCount(info.getWriteCount());
        }
        if (info.hasWriteBytes()) {
            report.setWriteBytes(info.getWriteBytes());
        }
        if (info.hasDeleteTransactionId()) {
            report.updateDeleteTransactionId(info.getDeleteTransactionId());
        }
        report.setContainerID(info.getContainerID());
        return report;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.ContainerInfo getProtoBufMessage() {
        return StorageContainerDatanodeProtocolProtos.ContainerInfo.newBuilder().setKeyCount(this.getKeyCount()).setSize(this.getSize()).setUsed(this.getBytesUsed()).setReadCount(this.getReadCount()).setReadBytes(this.getReadBytes()).setWriteCount(this.getWriteCount()).setWriteBytes(this.getWriteBytes()).setFinalhash(this.getFinalhash()).setContainerID(this.getContainerID()).setDeleteTransactionId(this.getDeleteTransactionId()).build();
    }
}

