/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.helpers;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;

public class ContainerReport {
    private static final int UNKNOWN = -1;
    private final String finalhash;
    private long size;
    private long keyCount;
    private long bytesUsed;
    private long readCount;
    private long writeCount;
    private long readBytes;
    private long writeBytes;
    private long containerID;

    public long getContainerID() {
        return this.containerID;
    }

    public void setContainerID(long containerID) {
        this.containerID = containerID;
    }

    public ContainerReport(long containerID, String finalhash) {
        this.containerID = containerID;
        this.finalhash = finalhash;
        this.size = -1L;
        this.keyCount = -1L;
        this.bytesUsed = 0L;
        this.readCount = 0L;
        this.readBytes = 0L;
        this.writeCount = 0L;
        this.writeBytes = 0L;
    }

    public static ContainerReport getFromProtoBuf(StorageContainerDatanodeProtocolProtos.ContainerInfo info) {
        Preconditions.checkNotNull((Object)info);
        ContainerReport report = new ContainerReport(info.getContainerID(), info.getFinalhash());
        if (info.hasSize()) {
            report.setSize(info.getSize());
        }
        if (info.hasKeyCount()) {
            report.setKeyCount(info.getKeyCount());
        }
        if (info.hasUsed()) {
            report.setBytesUsed(info.getUsed());
        }
        if (info.hasReadCount()) {
            report.setReadCount(info.getReadCount());
        }
        if (info.hasReadBytes()) {
            report.setReadBytes(info.getReadBytes());
        }
        if (info.hasWriteCount()) {
            report.setWriteCount(info.getWriteCount());
        }
        if (info.hasWriteBytes()) {
            report.setWriteBytes(info.getWriteBytes());
        }
        report.setContainerID(info.getContainerID());
        return report;
    }

    public String getFinalhash() {
        return this.finalhash;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public void setKeyCount(long keyCount) {
        this.keyCount = keyCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public void setReadCount(long readCount) {
        this.readCount = readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void setWriteCount(long writeCount) {
        this.writeCount = writeCount;
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public void setReadBytes(long readBytes) {
        this.readBytes = readBytes;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public void setWriteBytes(long writeBytes) {
        this.writeBytes = writeBytes;
    }

    public long getBytesUsed() {
        return this.bytesUsed;
    }

    public void setBytesUsed(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public StorageContainerDatanodeProtocolProtos.ContainerInfo getProtoBufMessage() {
        return StorageContainerDatanodeProtocolProtos.ContainerInfo.newBuilder().setKeyCount(this.getKeyCount()).setSize(this.getSize()).setUsed(this.getBytesUsed()).setReadCount(this.getReadCount()).setReadBytes(this.getReadBytes()).setWriteCount(this.getWriteCount()).setWriteBytes(this.getWriteBytes()).setFinalhash(this.getFinalhash()).setContainerID(this.getContainerID()).build();
    }
}

