/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.collect.ImmutableMap;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.ipc.BlockingRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public final class RpcClientFactory {
    public static final String CUSTOM_RPC_CLIENT_IMPL_CONF_KEY = "hbase.rpc.client.impl";
    private static final ImmutableMap<String, String> DEPRECATED_NAME_MAPPING = ImmutableMap.of((Object)"org.apache.hadoop.hbase.ipc.RpcClientImpl", (Object)BlockingRpcClient.class.getName(), (Object)"org.apache.hadoop.hbase.ipc.AsyncRpcClient", (Object)NettyRpcClient.class.getName());

    private RpcClientFactory() {
    }

    public static RpcClient createClient(Configuration conf, String clusterId) {
        return RpcClientFactory.createClient(conf, clusterId, null);
    }

    public static RpcClient createClient(Configuration conf, String clusterId, MetricsConnection metrics) {
        return RpcClientFactory.createClient(conf, clusterId, null, metrics);
    }

    private static String getRpcClientClass(Configuration conf) {
        String rpcClientClass = conf.get(CUSTOM_RPC_CLIENT_IMPL_CONF_KEY);
        if (rpcClientClass == null) {
            return BlockingRpcClient.class.getName();
        }
        String mappedName = (String)DEPRECATED_NAME_MAPPING.get((Object)rpcClientClass);
        return mappedName == null ? rpcClientClass : mappedName;
    }

    public static RpcClient createClient(Configuration conf, String clusterId, SocketAddress localAddr, MetricsConnection metrics) {
        String rpcClientClass = RpcClientFactory.getRpcClientClass(conf);
        return (RpcClient)ReflectionUtils.instantiateWithCustomCtor((String)rpcClientClass, (Class[])new Class[]{Configuration.class, String.class, SocketAddress.class, MetricsConnection.class}, (Object[])new Object[]{conf, clusterId, localAddr, metrics});
    }
}

