/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.lang.reflect.Method;
import org.apache.hadoop.fs.impl.prefetch.BlockOperations;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBlockOperations
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        BlockOperations ops = new BlockOperations();
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> ops.getPrefetched(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> ops.getCached(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> ops.getRead(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> ops.release(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> ops.requestPrefetch(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' must not be negative", () -> ops.requestCaching(-1));
    }

    @Test
    public void testGetSummary() throws Exception {
        this.verifySummary("getPrefetched", "GP");
        this.verifySummary("getCached", "GC");
        this.verifySummary("getRead", "GR");
        this.verifySummary("release", "RL");
        this.verifySummary("requestPrefetch", "RP");
        this.verifySummary("prefetch", "PF");
        this.verifySummary("requestCaching", "RC");
        this.verifySummary("addToCache", "C+");
        this.verifySummaryNoArg("cancelPrefetches", "CP");
        this.verifySummaryNoArg("close", "CX");
    }

    private void verifySummary(String methodName, String shortName) throws Exception {
        int blockNumber = 42;
        BlockOperations ops = new BlockOperations();
        Method method = ops.getClass().getDeclaredMethod(methodName, Integer.TYPE);
        BlockOperations.Operation op = (BlockOperations.Operation)method.invoke((Object)ops, blockNumber);
        ops.end(op);
        String summary = ops.getSummary(false);
        String opSummary = String.format("%s(%d)", shortName, blockNumber);
        String expectedSummary = String.format("%s;E%s;", opSummary, opSummary);
        Assert.assertTrue((boolean)summary.startsWith(expectedSummary));
    }

    private void verifySummaryNoArg(String methodName, String shortName) throws Exception {
        BlockOperations ops = new BlockOperations();
        Method method = ops.getClass().getDeclaredMethod(methodName, new Class[0]);
        BlockOperations.Operation op = (BlockOperations.Operation)method.invoke((Object)ops, new Object[0]);
        ops.end(op);
        String summary = ops.getSummary(false);
        String expectedSummary = String.format("%s;E%s;", shortName, shortName);
        Assert.assertTrue((boolean)summary.startsWith(expectedSummary));
    }
}

