/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AboutPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppAttemptPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppLogAggregationStatusPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.CapacitySchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.ContainerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.DefaultSchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.FairSchedulerPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodeLabelsPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NodesPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMErrorsAndWarningsPage;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RedirectionErrorPage;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;

public class RmController
extends Controller {
    @Inject
    RmController(Controller.RequestContext ctx) {
        super(ctx);
    }

    public void index() {
        this.setTitle("Applications");
    }

    public void about() {
        this.setTitle("About the Cluster");
        this.render(AboutPage.class);
    }

    public void app() {
        this.render(AppPage.class);
    }

    public void appattempt() {
        this.render(AppAttemptPage.class);
    }

    public void container() {
        this.render(ContainerPage.class);
    }

    public void failure() {
        this.render(RedirectionErrorPage.class);
    }

    public void nodes() {
        this.render(NodesPage.class);
    }

    public void scheduler() {
        this.set("app.state", StringHelper.cjoin((Object[])new Object[]{YarnApplicationState.NEW.toString(), YarnApplicationState.NEW_SAVING.toString(), YarnApplicationState.SUBMITTED.toString(), YarnApplicationState.ACCEPTED.toString(), YarnApplicationState.RUNNING.toString()}));
        ResourceManager rm = (ResourceManager)this.getInstance(ResourceManager.class);
        ResourceScheduler rs = rm.getResourceScheduler();
        if (rs == null || rs instanceof CapacityScheduler) {
            this.setTitle("Capacity Scheduler");
            this.render(CapacitySchedulerPage.class);
            return;
        }
        if (rs instanceof FairScheduler) {
            this.setTitle("Fair Scheduler");
            this.render(FairSchedulerPage.class);
            return;
        }
        if (rs instanceof FifoScheduler) {
            this.setTitle("FIFO Scheduler");
            this.render(DefaultSchedulerPage.class);
            return;
        }
        this.renderOtherPluginScheduler(rm);
    }

    private void renderOtherPluginScheduler(ResourceManager rm) {
        ResourceScheduler rs = rm.getResourceScheduler();
        String schedulerName = rs.getClass().getSimpleName();
        Class<? extends View> cls = PluginSchedulerPageHelper.getPageClass(rm.getConfig());
        if (cls != null) {
            this.setTitle(schedulerName);
            this.render(cls);
        } else {
            LOG.warn("Render default scheduler page as scheduler page configured doesn't exist");
            this.setTitle("Default Scheduler");
            this.render(DefaultSchedulerPage.class);
        }
    }

    public void queue() {
        this.setTitle(StringHelper.join((Object[])new Object[]{"Queue ", this.get("queue.name", "unknown")}));
    }

    public void submit() {
        this.setTitle("Application Submission Not Allowed");
    }

    public void nodelabels() {
        this.setTitle("Node Labels");
        this.render(NodeLabelsPage.class);
    }

    public void errorsAndWarnings() {
        this.render(RMErrorsAndWarningsPage.class);
    }

    public void logaggregationstatus() {
        this.render(AppLogAggregationStatusPage.class);
    }

    static class PluginSchedulerPageHelper {
        private static boolean hasLoaded = false;
        private static Class<? extends View> pageClass = null;

        PluginSchedulerPageHelper() {
        }

        public static Class<? extends View> getPageClass(Configuration conf) {
            if (!hasLoaded) {
                PluginSchedulerPageHelper.loadPluginSchedulerPageClass(conf);
                hasLoaded = true;
            }
            return pageClass;
        }

        private static void loadPluginSchedulerPageClass(Configuration conf) {
            Class configuredClass = conf.getClass("yarn.http.rmwebapp.scheduler.page.class", null);
            if (!View.class.isAssignableFrom(configuredClass)) {
                return;
            }
            pageClass = configuredClass;
        }
    }
}

