/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public class WebSessionServerSecurityContextRepository
implements ServerSecurityContextRepository {
    private static final Log logger = LogFactory.getLog(WebSessionServerSecurityContextRepository.class);
    public static final String DEFAULT_SPRING_SECURITY_CONTEXT_ATTR_NAME = "SPRING_SECURITY_CONTEXT";
    private String springSecurityContextAttrName = "SPRING_SECURITY_CONTEXT";

    public void setSpringSecurityContextAttrName(String springSecurityContextAttrName) {
        Assert.hasText(springSecurityContextAttrName, "springSecurityContextAttrName cannot be null or empty");
        this.springSecurityContextAttrName = springSecurityContextAttrName;
    }

    @Override
    public Mono<Void> save(ServerWebExchange exchange2, SecurityContext context) {
        return exchange2.getSession().doOnNext(session -> {
            if (context == null) {
                session.getAttributes().remove(this.springSecurityContextAttrName);
                logger.debug(LogMessage.format("Removed SecurityContext stored in WebSession: '%s'", session));
            } else {
                session.getAttributes().put(this.springSecurityContextAttrName, context);
                logger.debug(LogMessage.format("Saved SecurityContext '%s' in WebSession: '%s'", (Object)context, session));
            }
        }).flatMap(WebSession::changeSessionId);
    }

    @Override
    public Mono<SecurityContext> load(ServerWebExchange exchange2) {
        return exchange2.getSession().flatMap(session -> {
            SecurityContext context = (SecurityContext)session.getAttribute(this.springSecurityContextAttrName);
            logger.debug(context != null ? LogMessage.format("Found SecurityContext '%s' in WebSession: '%s'", (Object)context, session) : LogMessage.format("No SecurityContext found in WebSession: '%s'", session));
            return Mono.justOrEmpty((Object)context);
        });
    }
}

