/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.user;

import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.auth.totp.conf.ConfigurationService;
import org.apache.guacamole.auth.totp.form.AuthenticationCodeField;
import org.apache.guacamole.auth.totp.user.CodeUsageTrackingService;
import org.apache.guacamole.auth.totp.user.UserTOTPKey;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.language.TranslatableGuacamoleInsufficientCredentialsException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.totp.TOTPGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserVerificationService {
    private final Logger logger = LoggerFactory.getLogger(UserVerificationService.class);
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    @Inject
    private ConfigurationService confService;
    @Inject
    private CodeUsageTrackingService codeService;
    @Inject
    private Provider<AuthenticationCodeField> codeFieldProvider;

    private UserTOTPKey getKey(UserContext context, String username) throws GuacamoleException {
        byte[] key;
        User self = context.self();
        Map attributes = context.self().getAttributes();
        String secret = (String)attributes.get("guac-totp-key-secret");
        if (secret == null) {
            TOTPGenerator.Mode mode = this.confService.getMode();
            UserTOTPKey generated = new UserTOTPKey(username, mode.getRecommendedKeyLength());
            if (this.setKey(context, generated)) {
                return generated;
            }
            return null;
        }
        try {
            key = BASE32.decode(secret);
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("TOTP key of user \"{}\" is not valid base32.", (Object)self.getIdentifier());
            this.logger.debug("TOTP key is not valid base32.", (Throwable)e);
            return null;
        }
        boolean confirmed = "true".equals(attributes.get("guac-totp-key-confirmed"));
        return new UserTOTPKey(username, key, confirmed);
    }

    private boolean setKey(UserContext context, UserTOTPKey key) throws GuacamoleException {
        User self = context.self();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("guac-totp-key-secret", BASE32.encode(key.getSecret()));
        attributes.put("guac-totp-key-confirmed", key.isConfirmed() ? "true" : "false");
        self.setAttributes(attributes);
        Map setAttributes = self.getAttributes();
        if (!setAttributes.containsKey("guac-totp-key-secret") || !setAttributes.containsKey("guac-totp-key-confirmed")) {
            return false;
        }
        try {
            context.getPrivileged().getUserDirectory().update((Identifiable)self);
        }
        catch (GuacamoleSecurityException e) {
            this.logger.info("User \"{}\" cannot store their TOTP key as they lack permission to update their own account and the TOTP extension was unable to obtain privileged access. TOTP will be disabled for this user.", (Object)self.getIdentifier());
            this.logger.debug("Permission denied to set TOTP key of user account.", (Throwable)e);
            return false;
        }
        catch (GuacamoleUnsupportedException e) {
            this.logger.debug("Extension storage for user is explicitly read-only. Cannot update attributes to store TOTP key.", (Throwable)e);
            return false;
        }
        return true;
    }

    public void verifyIdentity(UserContext context, AuthenticatedUser authenticatedUser) throws GuacamoleException {
        String username = authenticatedUser.getIdentifier();
        if (username.equals("")) {
            return;
        }
        UserTOTPKey key = this.getKey(context, username);
        if (key == null) {
            return;
        }
        Credentials credentials = authenticatedUser.getCredentials();
        HttpServletRequest request = credentials.getRequest();
        String code = request.getParameter("guac-totp");
        if (code == null) {
            AuthenticationCodeField field = this.codeFieldProvider.get();
            if (!key.isConfirmed()) {
                field.exposeKey(key);
                throw new TranslatableGuacamoleInsufficientCredentialsException("TOTP enrollment must be completed before authentication can continue", "TOTP.INFO_ENROLL_REQUIRED", new CredentialsInfo(Collections.singletonList(field)));
            }
            throw new TranslatableGuacamoleInsufficientCredentialsException("A TOTP authentication code is required before login can continue", "TOTP.INFO_CODE_REQUIRED", new CredentialsInfo(Collections.singletonList(field)));
        }
        try {
            TOTPGenerator totp = new TOTPGenerator(key.getSecret(), this.confService.getMode(), this.confService.getDigits(), 0L, this.confService.getPeriod());
            if ((code.equals(totp.generate()) || code.equals(totp.previous())) && this.codeService.useCode(username, code)) {
                if (!key.isConfirmed()) {
                    key.setConfirmed(true);
                    this.setKey(context, key);
                }
                return;
            }
        }
        catch (InvalidKeyException e) {
            this.logger.warn("User \"{}\" is associated with an invalid TOTP key.", (Object)username);
            this.logger.debug("TOTP key is not valid.", (Throwable)e);
        }
        throw new TranslatableGuacamoleClientException("Provided TOTP code is not valid.", "TOTP.INFO_VERIFICATION_FAILED");
    }
}

