/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.saml.AuthenticationProviderService;
import org.apache.guacamole.auth.saml.SAMLAuthenticationProviderModule;
import org.apache.guacamole.auth.saml.SAMLAuthenticationProviderResource;
import org.apache.guacamole.auth.saml.SAMLResponseMap;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;

public class SAMLAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final Injector injector = Guice.createInjector(new SAMLAuthenticationProviderModule((AuthenticationProvider)this));

    public String getIdentifier() {
        return "saml";
    }

    public Object getResource() throws GuacamoleException {
        return this.injector.getInstance(SAMLAuthenticationProviderResource.class);
    }

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        AuthenticationProviderService authProviderService = this.injector.getInstance(AuthenticationProviderService.class);
        return authProviderService.authenticateUser(credentials);
    }

    public void shutdown() {
        this.injector.getInstance(SAMLResponseMap.class).shutdown();
    }
}

