/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.openid.conf.ConfigurationService;
import org.apache.guacamole.auth.openid.form.TokenField;
import org.apache.guacamole.auth.openid.token.NonceService;
import org.apache.guacamole.auth.openid.token.TokenValidationService;
import org.apache.guacamole.auth.openid.user.AuthenticatedUser;
import org.apache.guacamole.form.Field;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderService {
    private final Logger logger = LoggerFactory.getLogger(AuthenticationProviderService.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private NonceService nonceService;
    @Inject
    private TokenValidationService tokenService;
    @Inject
    private Provider<AuthenticatedUser> authenticatedUserProvider;

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        JwtClaims claims;
        String token;
        String username = null;
        Set<String> groups = null;
        HttpServletRequest request = credentials.getRequest();
        if (request != null && (token = request.getParameter("id_token")) != null && (claims = this.tokenService.validateToken(token)) != null) {
            username = this.tokenService.processUsername(claims);
            groups = this.tokenService.processGroups(claims);
        }
        if (username != null) {
            AuthenticatedUser authenticatedUser = this.authenticatedUserProvider.get();
            authenticatedUser.init(username, credentials, groups);
            return authenticatedUser;
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login.", new CredentialsInfo(Arrays.asList(new Field[]{new TokenField(this.confService.getAuthorizationEndpoint(), this.confService.getScope(), this.confService.getClientID(), this.confService.getRedirectURI(), this.nonceService.generate((long)this.confService.getMaxNonceValidity() * 60000L), new TranslatableMessage("LOGIN.INFO_OID_PENDING_REDIRECT"))})));
    }
}

