/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.postgresql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.postgresql.conf.PostgreSQLEnvironment;
import org.apache.guacamole.auth.postgresql.conf.PostgreSQLSSLMode;
import org.mybatis.guice.datasource.helper.JdbcHelper;

public class PostgreSQLAuthenticationProviderModule
implements Module {
    private final Properties myBatisProperties = new Properties();
    private final Properties driverProperties = new Properties();

    public PostgreSQLAuthenticationProviderModule(PostgreSQLEnvironment environment) throws GuacamoleException {
        this.myBatisProperties.setProperty("mybatis.environment.id", "guacamole");
        this.myBatisProperties.setProperty("JDBC.host", environment.getPostgreSQLHostname());
        this.myBatisProperties.setProperty("JDBC.port", String.valueOf(environment.getPostgreSQLPort()));
        this.myBatisProperties.setProperty("JDBC.schema", environment.getPostgreSQLDatabase());
        this.myBatisProperties.setProperty("JDBC.username", environment.getPostgreSQLUsername());
        this.myBatisProperties.setProperty("JDBC.password", environment.getPostgreSQLPassword());
        this.myBatisProperties.setProperty("JDBC.autoCommit", "false");
        this.myBatisProperties.setProperty("mybatis.pooled.pingEnabled", "true");
        this.myBatisProperties.setProperty("mybatis.pooled.pingQuery", "SELECT 1");
        int defaultStatementTimeout = environment.getPostgreSQLDefaultStatementTimeout();
        if (defaultStatementTimeout > 0) {
            this.myBatisProperties.setProperty("mybatis.configuration.defaultStatementTimeout", String.valueOf(defaultStatementTimeout));
        }
        this.driverProperties.setProperty("characterEncoding", "UTF-8");
        PostgreSQLSSLMode sslMode = environment.getPostgreSQLSSLMode();
        if (sslMode != PostgreSQLSSLMode.PREFER) {
            this.driverProperties.setProperty("sslmode", sslMode.getDriverValue());
        }
        if (sslMode == PostgreSQLSSLMode.DISABLE) {
            this.driverProperties.setProperty("ssl", "false");
        } else {
            String sslClientKeyPassword;
            File sslRootCert;
            File sslClientKey;
            File sslClientCert = environment.getPostgreSQLSSLClientCertFile();
            if (sslClientCert != null) {
                this.driverProperties.setProperty("sslcert", sslClientCert.getAbsolutePath());
            }
            if ((sslClientKey = environment.getPostgreSQLSSLClientKeyFile()) != null) {
                this.driverProperties.setProperty("sslkey", sslClientKey.getAbsolutePath());
            }
            if ((sslRootCert = environment.getPostgreSQLSSLClientRootCertFile()) != null) {
                this.driverProperties.setProperty("sslrootcert", sslRootCert.getAbsolutePath());
            }
            if ((sslClientKeyPassword = environment.getPostgreSQLSSLClientKeyPassword()) != null) {
                this.driverProperties.setProperty("sslpassword", sslClientKeyPassword);
            }
        }
        this.driverProperties.setProperty("socketTimeout", String.valueOf(environment.getPostgreSQLSocketTimeout()));
    }

    @Override
    public void configure(Binder binder) {
        JdbcHelper.PostgreSQL.configure(binder);
        Names.bindProperties(binder, this.myBatisProperties);
        binder.bind(Properties.class).annotatedWith(Names.named("JDBC.driverProperties")).toInstance(this.driverProperties);
    }
}

