/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas;

import com.google.inject.Guice;
import com.google.inject.Injector;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.cas.AuthenticationProviderService;
import org.apache.guacamole.auth.cas.CASAuthenticationProviderModule;
import org.apache.guacamole.auth.cas.user.CASAuthenticatedUser;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.TokenInjectingUserContext;
import org.apache.guacamole.net.auth.UserContext;

public class CASAuthenticationProvider
extends AbstractAuthenticationProvider {
    private final Injector injector = Guice.createInjector(new CASAuthenticationProviderModule((AuthenticationProvider)this));

    public String getIdentifier() {
        return "cas";
    }

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        AuthenticationProviderService authProviderService = this.injector.getInstance(AuthenticationProviderService.class);
        return authProviderService.authenticateUser(credentials);
    }

    public UserContext decorate(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        if (!(authenticatedUser instanceof CASAuthenticatedUser)) {
            return context;
        }
        return new TokenInjectingUserContext(context, ((CASAuthenticatedUser)authenticatedUser).getTokens());
    }
}

