/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.form;

import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.totp.conf.ConfigurationService;
import org.apache.guacamole.auth.totp.user.UserTOTPKey;
import org.apache.guacamole.form.Field;
import org.apache.guacamole.totp.TOTPGenerator;
import org.codehaus.jackson.annotate.JsonProperty;

public class AuthenticationCodeField
extends Field {
    public static final String PARAMETER_NAME = "guac-totp";
    private static final String FIELD_TYPE_NAME = "GUAC_TOTP_CODE";
    private static final int QR_CODE_WIDTH = 256;
    private static final int QR_CODE_HEIGHT = 256;
    private static final BaseEncoding BASE32 = BaseEncoding.base32();
    @Inject
    private ConfigurationService confService;
    private UserTOTPKey key;

    public AuthenticationCodeField() {
        super(PARAMETER_NAME, FIELD_TYPE_NAME);
    }

    public void exposeKey(UserTOTPKey key) {
        this.key = key;
    }

    public String getUsername() {
        if (this.key == null) {
            return null;
        }
        return this.key.getUsername();
    }

    public String getSecret() {
        if (this.key == null) {
            return null;
        }
        return BASE32.encode(this.key.getSecret());
    }

    public Integer getDigits() throws GuacamoleException {
        if (this.key == null) {
            return null;
        }
        return this.confService.getDigits();
    }

    public String getIssuer() throws GuacamoleException {
        if (this.key == null) {
            return null;
        }
        return this.confService.getIssuer();
    }

    public TOTPGenerator.Mode getMode() throws GuacamoleException {
        if (this.key == null) {
            return null;
        }
        return this.confService.getMode();
    }

    public Integer getPeriod() throws GuacamoleException {
        if (this.key == null) {
            return null;
        }
        return this.confService.getPeriod();
    }

    @JsonProperty(value="keyUri")
    public URI getKeyURI() throws GuacamoleException {
        if (this.key == null) {
            return null;
        }
        String issuer = this.confService.getIssuer();
        return UriBuilder.fromUri((String)"otpauth://totp/").path(issuer + ":" + this.key.getUsername()).queryParam("secret", new Object[]{BASE32.encode(this.key.getSecret())}).queryParam("issuer", new Object[]{issuer}).queryParam("algorithm", new Object[]{this.confService.getMode()}).queryParam("digits", new Object[]{this.confService.getDigits()}).queryParam("period", new Object[]{this.confService.getPeriod()}).build(new Object[0]);
    }

    @JsonProperty(value="qrCode")
    public String getQRCode() throws GuacamoleException {
        URI keyURI = this.getKeyURI();
        if (keyURI == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix matrix = writer.encode(keyURI.toString(), BarcodeFormat.QR_CODE, 256, 256);
            MatrixToImageWriter.writeToStream(matrix, "PNG", stream);
        }
        catch (WriterException e) {
            throw new IllegalArgumentException("QR code could not be generated for TOTP key.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Image stream of QR code could not be written.", e);
        }
        return "data:image/png;base64," + BaseEncoding.base64().encode(stream.toByteArray());
    }
}

