/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml.conf;

import com.google.inject.Inject;
import com.onelogin.saml2.settings.IdPMetadataParser;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import com.onelogin.saml2.util.Constants;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.BooleanGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;
import org.apache.guacamole.properties.URIGuacamoleProperty;

public class ConfigurationService {
    private static final URIGuacamoleProperty SAML_IDP_METADATA_URL = new URIGuacamoleProperty(){

        public String getName() {
            return "saml-idp-metadata-url";
        }
    };
    private static final URIGuacamoleProperty SAML_IDP_URL = new URIGuacamoleProperty(){

        public String getName() {
            return "saml-idp-url";
        }
    };
    private static final URIGuacamoleProperty SAML_ENTITY_ID = new URIGuacamoleProperty(){

        public String getName() {
            return "saml-entity-id";
        }
    };
    private static final URIGuacamoleProperty SAML_CALLBACK_URL = new URIGuacamoleProperty(){

        public String getName() {
            return "saml-callback-url";
        }
    };
    private static final BooleanGuacamoleProperty SAML_DEBUG = new BooleanGuacamoleProperty(){

        public String getName() {
            return "saml-debug";
        }
    };
    private static final BooleanGuacamoleProperty SAML_COMPRESS_REQUEST = new BooleanGuacamoleProperty(){

        public String getName() {
            return "saml-compress-request";
        }
    };
    private static final BooleanGuacamoleProperty SAML_COMPRESS_RESPONSE = new BooleanGuacamoleProperty(){

        public String getName() {
            return "saml-compress-response";
        }
    };
    private static final BooleanGuacamoleProperty SAML_STRICT = new BooleanGuacamoleProperty(){

        public String getName() {
            return "saml-strict";
        }
    };
    private static final StringGuacamoleProperty SAML_GROUP_ATTRIBUTE = new StringGuacamoleProperty(){

        public String getName() {
            return "saml-group-attribute";
        }
    };
    @Inject
    private Environment environment;

    private URI getEntityId() throws GuacamoleException {
        return (URI)this.environment.getProperty((GuacamoleProperty)SAML_ENTITY_ID);
    }

    private URI getIdpMetadata() throws GuacamoleException {
        return (URI)this.environment.getProperty((GuacamoleProperty)SAML_IDP_METADATA_URL);
    }

    private URI getIdpUrl() throws GuacamoleException {
        return (URI)this.environment.getProperty((GuacamoleProperty)SAML_IDP_URL);
    }

    public URI getCallbackUrl() throws GuacamoleException {
        return (URI)this.environment.getRequiredProperty((GuacamoleProperty)SAML_CALLBACK_URL);
    }

    private boolean getDebug() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)SAML_DEBUG, (Object)false);
    }

    private boolean getCompressRequest() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)SAML_COMPRESS_REQUEST, (Object)true);
    }

    private boolean getStrict() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)SAML_STRICT, (Object)true);
    }

    private boolean getCompressResponse() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)SAML_COMPRESS_RESPONSE, (Object)true);
    }

    public String getGroupAttribute() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)SAML_GROUP_ATTRIBUTE, (Object)"groups");
    }

    public Saml2Settings getSamlSettings() throws GuacamoleException {
        Map<Object, Object> samlMap;
        URI idpMetadata = this.getIdpMetadata();
        if (idpMetadata != null) {
            try {
                samlMap = IdPMetadataParser.parseRemoteXML(idpMetadata.toURL());
            }
            catch (Exception e) {
                throw new GuacamoleServerException("Could not parse SAML IdP Metadata file.", (Throwable)e);
            }
        } else {
            samlMap = new HashMap();
            samlMap.put("onelogin.saml2.idp.entityid", this.getIdpUrl().toString());
            samlMap.put("onelogin.saml2.idp.single_sign_on_service.url", this.getIdpUrl().toString());
            samlMap.put("onelogin.saml2.idp.single_sign_on_service.binding", Constants.BINDING_HTTP_REDIRECT);
        }
        if (!samlMap.containsKey("onelogin.saml2.sp.entityid")) {
            URI entityId = this.getEntityId();
            if (entityId == null) {
                throw new GuacamoleServerException("SAML Entity ID was not found in either the metadata XML file or guacamole.properties");
            }
            samlMap.put("onelogin.saml2.sp.entityid", entityId.toString());
        }
        if (!samlMap.containsKey("onelogin.saml2.sp.assertion_consumer_service.url")) {
            samlMap.put("onelogin.saml2.sp.assertion_consumer_service.url", UriBuilder.fromUri((URI)this.getCallbackUrl()).path("api/ext/saml/callback").build(new Object[0]).toString());
        }
        SettingsBuilder samlBuilder = new SettingsBuilder();
        Saml2Settings samlSettings = samlBuilder.fromValues(samlMap).build();
        samlSettings.setStrict(this.getStrict());
        samlSettings.setDebug(this.getDebug());
        samlSettings.setCompressRequest(this.getCompressRequest());
        samlSettings.setCompressResponse(this.getCompressResponse());
        return samlSettings;
    }
}

