/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml;

import com.google.inject.Singleton;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.ValidationError;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Singleton
public class SAMLResponseMap {
    private final ConcurrentMap<String, SamlResponse> samlResponseMap = new ConcurrentHashMap<String, SamlResponse>();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public SAMLResponseMap() {
        this.executor.scheduleAtFixedRate(new SAMLResponseCleanupTask(), 5L, 5L, TimeUnit.MINUTES);
    }

    protected SamlResponse getSamlResponse(String hash) {
        return (SamlResponse)this.samlResponseMap.remove(hash);
    }

    protected void putSamlResponse(String hash, SamlResponse samlResponse) {
        this.samlResponseMap.put(hash, samlResponse);
    }

    protected boolean hasSamlResponse(String hash) {
        return this.samlResponseMap.containsKey(hash);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private class SAMLResponseCleanupTask
    implements Runnable {
        private SAMLResponseCleanupTask() {
        }

        @Override
        public void run() {
            Iterator responseIterator = SAMLResponseMap.this.samlResponseMap.values().iterator();
            while (responseIterator.hasNext()) {
                try {
                    ((SamlResponse)responseIterator.next()).validateTimestamps();
                }
                catch (ValidationError e) {
                    responseIterator.remove();
                }
            }
        }
    }
}

