/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml;

import com.google.inject.Inject;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.exception.ValidationError;
import com.onelogin.saml2.http.HttpRequest;
import com.onelogin.saml2.servlet.ServletUtils;
import com.onelogin.saml2.settings.Saml2Settings;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.saml.SAMLResponseMap;
import org.apache.guacamole.auth.saml.conf.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SAMLAuthenticationProviderResource {
    private final Logger logger = LoggerFactory.getLogger(SAMLAuthenticationProviderResource.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private SAMLResponseMap samlResponseMap;

    @POST
    @Path(value="callback")
    public Response processSamlResponse(@FormParam(value="SAMLResponse") String samlResponseString, @Context HttpServletRequest consumedRequest) throws GuacamoleException {
        URI guacBase = this.confService.getCallbackUrl();
        Saml2Settings samlSettings = this.confService.getSamlSettings();
        try {
            HttpRequest request = ServletUtils.makeHttpRequest(consumedRequest).addParameter("SAMLResponse", samlResponseString);
            SamlResponse samlResponse = new SamlResponse(samlSettings, request);
            String responseHash = this.hashSamlResponse(samlResponseString);
            this.samlResponseMap.putSamlResponse(responseHash, samlResponse);
            return Response.seeOther((URI)UriBuilder.fromUri((URI)guacBase).queryParam("responseHash", new Object[]{responseHash}).build(new Object[0])).build();
        }
        catch (IOException e) {
            throw new GuacamoleServerException("I/O exception processing SAML response.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GuacamoleServerException("Unexpected missing SHA-256 support while generating SAML response hash.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new GuacamoleServerException("Parser exception processing SAML response.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new GuacamoleServerException("SAX exception processing SAML response.", (Throwable)e);
        }
        catch (SettingsException e) {
            throw new GuacamoleServerException("Settings exception processing SAML response.", (Throwable)e);
        }
        catch (ValidationError e) {
            throw new GuacamoleServerException("Exception validating SAML response.", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            throw new GuacamoleServerException("XML Xpath exception validating SAML response.", (Throwable)e);
        }
    }

    private String hashSamlResponse(String samlResponse) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return DatatypeConverter.printHexBinary((byte[])digest.digest(samlResponse.getBytes(StandardCharsets.UTF_8)));
    }
}

