/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.saml;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.authn.SamlResponse;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.exception.ValidationError;
import com.onelogin.saml2.settings.Saml2Settings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.saml.SAMLResponseMap;
import org.apache.guacamole.auth.saml.conf.ConfigurationService;
import org.apache.guacamole.auth.saml.user.SAMLAuthenticatedUser;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInsufficientCredentialsException;
import org.apache.guacamole.token.TokenName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AuthenticationProviderService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationProviderService.class);
    @Inject
    private ConfigurationService confService;
    @Inject
    private Provider<SAMLAuthenticatedUser> authenticatedUserProvider;
    @Inject
    private SAMLResponseMap samlResponseMap;
    private static final String SAML_ATTRIBUTE_TOKEN_PREFIX = "SAML_";

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        URI authUri;
        String responseHash;
        HttpServletRequest request = credentials.getRequest();
        Saml2Settings samlSettings = this.confService.getSamlSettings();
        if (request != null && (responseHash = request.getParameter("responseHash")) != null && this.samlResponseMap.hasSamlResponse(responseHash)) {
            try {
                SamlResponse samlResponse = this.samlResponseMap.getSamlResponse(responseHash);
                if (!samlResponse.validateNumAssertions().booleanValue()) {
                    logger.warn("SAML response contained other than single assertion.");
                    logger.debug("validateNumAssertions returned false.");
                    throw new GuacamoleServerException("Unable to validate SAML assertions.");
                }
                samlResponse.validateTimestamps();
                String username = samlResponse.getNameId();
                if (username != null) {
                    username = username.toLowerCase();
                    HashMap<String, List<String>> attributes = samlResponse.getAttributes();
                    credentials.setUsername(username);
                    SAMLAuthenticatedUser authenticatedUser = this.authenticatedUserProvider.get();
                    authenticatedUser.init(username, credentials, this.parseTokens(attributes), this.parseGroups(attributes, this.confService.getGroupAttribute()));
                    return authenticatedUser;
                }
            }
            catch (IOException e) {
                logger.warn("Error during I/O while parsing SAML response: {}", (Object)e.getMessage());
                logger.debug("Received IOException when trying to parse SAML response.", (Throwable)e);
                throw new GuacamoleServerException("IOException received while processing SAML response.", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                logger.warn("Error configuring XML parser: {}", (Object)e.getMessage());
                logger.debug("Received ParserConfigurationException when trying to parse SAML response.", (Throwable)e);
                throw new GuacamoleServerException("XML ParserConfigurationException received while processing SAML response.", (Throwable)e);
            }
            catch (SAXException e) {
                logger.warn("Bad XML when parsing SAML response: {}", (Object)e.getMessage());
                logger.debug("Received SAXException while parsing SAML response.", (Throwable)e);
                throw new GuacamoleServerException("XML SAXException received while processing SAML response.", (Throwable)e);
            }
            catch (SettingsException e) {
                logger.warn("Error with SAML settings while parsing response: {}", (Object)e.getMessage());
                logger.debug("Received SettingsException while parsing SAML response.", (Throwable)e);
                throw new GuacamoleServerException("SAML SettingsException received while process SAML response.", (Throwable)e);
            }
            catch (ValidationError e) {
                logger.warn("Error validating SAML response: {}", (Object)e.getMessage());
                logger.debug("Received ValidationError while parsing SAML response.", (Throwable)e);
                throw new GuacamoleServerException("SAML ValidationError received while processing SAML response.", (Throwable)e);
            }
            catch (XPathExpressionException e) {
                logger.warn("Problem with XML parsing response: {}", (Object)e.getMessage());
                logger.debug("Received XPathExpressionException while processing SAML response.", (Throwable)e);
                throw new GuacamoleServerException("XML XPathExpressionExcetion received while processing SAML response.", (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("Exception while getting name from SAML response: {}", (Object)e.getMessage());
                logger.debug("Received Exception while retrieving name from SAML response.", (Throwable)e);
                throw new GuacamoleServerException("Generic Exception received processing SAML response.", (Throwable)e);
            }
        }
        AuthnRequest samlReq = new AuthnRequest(samlSettings);
        try {
            authUri = UriBuilder.fromUri((URI)samlSettings.getIdpSingleSignOnServiceUrl().toURI()).queryParam("SAMLRequest", new Object[]{samlReq.getEncodedAuthnRequest()}).build(new Object[0]);
        }
        catch (IOException e) {
            logger.error("Error encoding authentication request to string: {}", (Object)e.getMessage());
            logger.debug("Got IOException encoding authentication request.", (Throwable)e);
            throw new GuacamoleServerException("IOException received while generating SAML authentication URI.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            logger.error("Error generating URI for authentication redirect: {}", (Object)e.getMessage());
            logger.debug("Got URISyntaxException generating authentication URI", (Throwable)e);
            throw new GuacamoleServerException("URISyntaxException received while generating SAML authentication URI.", (Throwable)e);
        }
        throw new GuacamoleInsufficientCredentialsException("Redirecting to SAML IdP.", new CredentialsInfo(Arrays.asList(new RedirectField("samlRedirect", authUri, new TranslatableMessage("LOGIN.INFO_SAML_REDIRECT_PENDING")))));
    }

    private Map<String, String> parseTokens(Map<String, List<String>> attributes) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : attributes.entrySet()) {
            List<String> values = entry.getValue();
            tokens.put(TokenName.canonicalize((String)entry.getKey(), (String)SAML_ATTRIBUTE_TOKEN_PREFIX), values.get(0));
        }
        return tokens;
    }

    private Set<String> parseGroups(Map<String, List<String>> attributes, String groupAttribute) {
        List<String> samlGroups = attributes.get(groupAttribute);
        if (samlGroups != null && !samlGroups.isEmpty()) {
            return Collections.unmodifiableSet(new HashSet<String>(samlGroups));
        }
        return Collections.emptySet();
    }
}

