/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.quickconnect.utility;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class QCParser {
    private static final Pattern userinfoPattern = Pattern.compile("(^[^:]+):?(.*)");
    private static final int USERNAME_GROUP = 1;
    private static final int PASSWORD_GROUP = 2;

    public static GuacamoleConfiguration getConfiguration(String uri) throws GuacamoleException {
        URI qcUri;
        try {
            qcUri = new URI(uri);
            if (!qcUri.isAbsolute()) {
                throw new TranslatableGuacamoleClientException("URI must be absolute.", "QUICKCONNECT.ERROR_NOT_ABSOLUTE_URI");
            }
        }
        catch (URISyntaxException e) {
            throw new TranslatableGuacamoleClientException("Invalid URI Syntax", "QUICKCONNECT.ERROR_INVALID_URI");
        }
        String protocol = qcUri.getScheme();
        String host = qcUri.getHost();
        int port = qcUri.getPort();
        String userInfo = qcUri.getUserInfo();
        String query = qcUri.getQuery();
        GuacamoleConfiguration qcConfig = new GuacamoleConfiguration();
        if (protocol == null || protocol.isEmpty()) {
            throw new TranslatableGuacamoleClientException("No protocol specified.", "QUICKCONNECT.ERROR_NO_PROTOCOL");
        }
        qcConfig.setProtocol(protocol);
        if (port > 0) {
            qcConfig.setParameter("port", Integer.toString(port));
        }
        if (host == null || host.isEmpty()) {
            throw new TranslatableGuacamoleClientException("No host specified.", "QUICKCONNECT.ERROR_NO_HOST");
        }
        qcConfig.setParameter("hostname", host);
        if (query != null && !query.isEmpty()) {
            try {
                Map<String, String> queryParams = QCParser.parseQueryString(query);
                if (queryParams != null) {
                    for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                        qcConfig.setParameter(entry.getKey(), entry.getValue());
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new GuacamoleServerException("Unexpected lack of UTF-8 encoding support.", (Throwable)e);
            }
        }
        if (userInfo != null && !userInfo.isEmpty()) {
            try {
                QCParser.parseUserInfo(userInfo, qcConfig);
            }
            catch (UnsupportedEncodingException e) {
                throw new GuacamoleServerException("Unexpected lack of UTF-8 encoding support.", (Throwable)e);
            }
        }
        return qcConfig;
    }

    public static Map<String, String> parseQueryString(String queryStr) throws UnsupportedEncodingException {
        List<String> paramList = Arrays.asList(queryStr.split("&"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String param : paramList) {
            String[] paramArray = param.split("=", 2);
            parameters.put(URLDecoder.decode(paramArray[0], "UTF-8"), URLDecoder.decode(paramArray[1], "UTF-8"));
        }
        return parameters;
    }

    public static void parseUserInfo(String userInfo, GuacamoleConfiguration config) throws UnsupportedEncodingException {
        Matcher userinfoMatcher = userinfoPattern.matcher(userInfo);
        if (userinfoMatcher.matches()) {
            String username = userinfoMatcher.group(1);
            String password = userinfoMatcher.group(2);
            if (username != null && !username.isEmpty()) {
                config.setParameter("username", URLDecoder.decode(username, "UTF-8"));
            }
            if (password != null && !password.isEmpty()) {
                config.setParameter("password", URLDecoder.decode(password, "UTF-8"));
            }
        }
    }

    public static String getName(GuacamoleConfiguration config) throws GuacamoleException {
        if (config == null) {
            return null;
        }
        String protocol = config.getProtocol();
        String host = config.getParameter("hostname");
        String port = config.getParameter("port");
        String user = config.getParameter("username");
        StringBuilder name = new StringBuilder();
        if (protocol != null && !protocol.isEmpty()) {
            name.append(protocol).append("://");
        }
        if (user != null && !user.isEmpty()) {
            name.append(user).append("@");
        }
        if (host != null && !host.isEmpty()) {
            name.append(host);
        }
        if (port != null && !port.isEmpty()) {
            name.append(":").append(port);
        }
        name.append("/");
        return name.toString();
    }
}

