/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.user;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleClientException;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.GuacamoleUnsupportedException;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordModel;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordSearchTerm;
import org.apache.guacamole.auth.jdbc.base.ActivityRecordSortPredicate;
import org.apache.guacamole.auth.jdbc.base.EntityMapper;
import org.apache.guacamole.auth.jdbc.base.ModeledActivityRecord;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectMapper;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectService;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionModel;
import org.apache.guacamole.auth.jdbc.permission.UserPermissionMapper;
import org.apache.guacamole.auth.jdbc.security.PasswordEncryptionService;
import org.apache.guacamole.auth.jdbc.security.PasswordPolicyService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.auth.jdbc.user.UserMapper;
import org.apache.guacamole.auth.jdbc.user.UserModel;
import org.apache.guacamole.auth.jdbc.user.UserRecordMapper;
import org.apache.guacamole.form.Field;
import org.apache.guacamole.form.PasswordField;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.language.TranslatableGuacamoleInsufficientCredentialsException;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.apache.guacamole.net.auth.permission.SystemPermissionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService
extends ModeledDirectoryObjectService<ModeledUser, User, UserModel> {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    private static final ObjectPermission.Type[] IMPLICIT_USER_PERMISSIONS = new ObjectPermission.Type[]{ObjectPermission.Type.READ};
    private static final String NEW_PASSWORD_PARAMETER = "new-password";
    private static final Field NEW_PASSWORD = new PasswordField("new-password");
    private static final String CONFIRM_NEW_PASSWORD_PARAMETER = "confirm-new-password";
    private static final Field CONFIRM_NEW_PASSWORD = new PasswordField("confirm-new-password");
    private static final CredentialsInfo EXPIRED_PASSWORD = new CredentialsInfo(Arrays.asList(CredentialsInfo.USERNAME, CredentialsInfo.PASSWORD, NEW_PASSWORD, CONFIRM_NEW_PASSWORD));
    @Inject
    private EntityMapper entityMapper;
    @Inject
    private UserMapper userMapper;
    @Inject
    private UserPermissionMapper userPermissionMapper;
    @Inject
    private UserRecordMapper userRecordMapper;
    @Inject
    private Provider<ModeledUser> userProvider;
    @Inject
    private PasswordEncryptionService encryptionService;
    @Inject
    private PasswordPolicyService passwordPolicyService;

    @Override
    protected ModeledDirectoryObjectMapper<UserModel> getObjectMapper() {
        return this.userMapper;
    }

    @Override
    protected ObjectPermissionMapper getPermissionMapper() {
        return this.userPermissionMapper;
    }

    @Override
    protected ModeledUser getObjectInstance(ModeledAuthenticatedUser currentUser, UserModel model) throws GuacamoleException {
        boolean exposeRestrictedAttributes = model.getObjectID() == null ? true : (currentUser != null ? this.hasObjectPermission(currentUser, model.getIdentifier(), ObjectPermission.Type.ADMINISTER) : false);
        ModeledUser user = this.userProvider.get();
        user.init(currentUser, model, exposeRestrictedAttributes);
        return user;
    }

    @Override
    protected UserModel getModelInstance(ModeledAuthenticatedUser currentUser, User object) throws GuacamoleException {
        UserModel model = new UserModel();
        ModeledUser user = this.getObjectInstance(currentUser, model);
        user.setIdentifier(object.getIdentifier());
        user.setPassword(object.getPassword());
        user.setAttributes(object.getAttributes());
        return model;
    }

    @Override
    protected boolean hasCreatePermission(ModeledAuthenticatedUser user) throws GuacamoleException {
        SystemPermissionSet permissionSet = user.getUser().getEffectivePermissions().getSystemPermissions();
        return permissionSet.hasPermission(SystemPermission.Type.CREATE_USER);
    }

    @Override
    protected ObjectPermissionSet getEffectivePermissionSet(ModeledAuthenticatedUser user) throws GuacamoleException {
        return user.getUser().getEffectivePermissions().getUserPermissions();
    }

    @Override
    protected void beforeCreate(ModeledAuthenticatedUser user, User object, UserModel model) throws GuacamoleException {
        super.beforeCreate(user, object, model);
        if (model.getIdentifier() == null || model.getIdentifier().trim().isEmpty()) {
            throw new GuacamoleClientException("The username must not be blank.");
        }
        Collection existing = this.userMapper.select(Collections.singleton(model.getIdentifier()));
        if (!existing.isEmpty()) {
            throw new GuacamoleClientException("User \"" + model.getIdentifier() + "\" already exists.");
        }
        if (object.getPassword() != null) {
            this.passwordPolicyService.verifyPassword(object.getIdentifier(), object.getPassword());
        }
        this.entityMapper.insert(model);
    }

    @Override
    protected void beforeUpdate(ModeledAuthenticatedUser user, ModeledUser object, UserModel model) throws GuacamoleException {
        super.beforeUpdate(user, object, model);
        if (model.getIdentifier() == null || model.getIdentifier().trim().isEmpty()) {
            throw new GuacamoleClientException("The username must not be blank.");
        }
        UserModel existing = this.userMapper.selectOne(model.getIdentifier());
        if (existing != null && !existing.getObjectID().equals(model.getObjectID())) {
            throw new GuacamoleClientException("User \"" + model.getIdentifier() + "\" already exists.");
        }
        if (object.getPassword() != null) {
            if (!user.isPrivileged()) {
                this.passwordPolicyService.verifyPasswordAge(object);
            }
            this.passwordPolicyService.verifyPassword(object.getIdentifier(), object.getPassword());
            this.passwordPolicyService.recordPassword(object);
        }
    }

    @Override
    protected Collection<ObjectPermissionModel> getImplicitPermissions(ModeledAuthenticatedUser user, UserModel model) {
        ArrayList<ObjectPermissionModel> implicitPermissions = new ArrayList<ObjectPermissionModel>(super.getImplicitPermissions(user, model));
        for (ObjectPermission.Type permissionType : IMPLICIT_USER_PERMISSIONS) {
            ObjectPermissionModel permissionModel = new ObjectPermissionModel();
            permissionModel.setEntityID(model.getEntityID());
            permissionModel.setType(permissionType);
            permissionModel.setObjectIdentifier(model.getIdentifier());
            implicitPermissions.add(permissionModel);
        }
        return Collections.unmodifiableCollection(implicitPermissions);
    }

    @Override
    protected void beforeDelete(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        super.beforeDelete(user, identifier);
        if (identifier.equals(user.getUser().getIdentifier())) {
            throw new GuacamoleUnsupportedException("Deleting your own user is not allowed.");
        }
    }

    @Override
    protected boolean isValidIdentifier(String identifier) {
        return true;
    }

    public ModeledAuthenticatedUser retrieveAuthenticatedUser(AuthenticationProvider authenticationProvider, Credentials credentials) throws GuacamoleException {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        UserModel userModel = this.userMapper.selectOne(username);
        if (userModel == null) {
            return null;
        }
        byte[] hash = this.encryptionService.createPasswordHash(password, userModel.getPasswordSalt());
        if (!Arrays.equals(hash, userModel.getPasswordHash())) {
            return null;
        }
        ModeledUser user = this.getObjectInstance((ModeledAuthenticatedUser)null, userModel);
        user.setCurrentUser(new ModeledAuthenticatedUser(authenticationProvider, user, credentials));
        return user.getCurrentUser();
    }

    public ModeledUser retrieveUser(AuthenticationProvider authenticationProvider, AuthenticatedUser authenticatedUser) throws GuacamoleException {
        if (authenticatedUser instanceof ModeledAuthenticatedUser) {
            return ((ModeledAuthenticatedUser)authenticatedUser).getUser();
        }
        UserModel userModel = this.userMapper.selectOne(authenticatedUser.getIdentifier());
        if (userModel == null) {
            return null;
        }
        ModeledUser user = this.getObjectInstance((ModeledAuthenticatedUser)null, userModel);
        user.setCurrentUser(new ModeledAuthenticatedUser(authenticatedUser, authenticationProvider, user));
        return user;
    }

    public ModeledUser retrieveSkeletonUser(AuthenticationProvider authenticationProvider, AuthenticatedUser authenticatedUser) throws GuacamoleException {
        ModeledUser user = this.getObjectInstance((ModeledAuthenticatedUser)null, new UserModel(authenticatedUser.getIdentifier()));
        user.setCurrentUser(new ModeledAuthenticatedUser(authenticatedUser, authenticationProvider, user));
        return user;
    }

    public void resetExpiredPassword(ModeledUser user, Credentials credentials) throws GuacamoleException {
        UserModel userModel = (UserModel)user.getModel();
        String username = user.getIdentifier();
        HttpServletRequest request = credentials.getRequest();
        String newPassword = request.getParameter(NEW_PASSWORD_PARAMETER);
        String confirmNewPassword = request.getParameter(CONFIRM_NEW_PASSWORD_PARAMETER);
        if (newPassword == null || confirmNewPassword == null) {
            logger.info("The password of user \"{}\" has expired and must be reset.", (Object)username);
            throw new TranslatableGuacamoleInsufficientCredentialsException("Password has expired", "LOGIN.INFO_PASSWORD_EXPIRED", EXPIRED_PASSWORD);
        }
        if (newPassword.equals(credentials.getPassword())) {
            throw new TranslatableGuacamoleClientException("New passwords may not be identical to the current password if password reset is required.", "LOGIN.ERROR_PASSWORD_SAME");
        }
        if (newPassword.isEmpty()) {
            throw new TranslatableGuacamoleClientException("Passwords may not be blank.", "LOGIN.ERROR_PASSWORD_BLANK");
        }
        if (!newPassword.equals(confirmNewPassword)) {
            throw new TranslatableGuacamoleClientException("New password does not match.", "LOGIN.ERROR_PASSWORD_MISMATCH");
        }
        this.passwordPolicyService.verifyPassword(username, newPassword);
        userModel.setExpired(false);
        user.setPassword(newPassword);
        this.userMapper.update(userModel);
        logger.info("Expired password of user \"{}\" has been reset.", (Object)username);
    }

    protected ActivityRecord getObjectInstance(ActivityRecordModel model) {
        return new ModeledActivityRecord(model);
    }

    protected List<ActivityRecord> getObjectInstances(List<ActivityRecordModel> models) {
        ArrayList<ActivityRecord> objects = new ArrayList<ActivityRecord>(models.size());
        for (ActivityRecordModel model : models) {
            objects.add(this.getObjectInstance(model));
        }
        return objects;
    }

    public List<ActivityRecord> retrieveHistory(ModeledAuthenticatedUser authenticatedUser, ModeledUser user) throws GuacamoleException {
        String username = user.getIdentifier();
        if (this.hasObjectPermission(authenticatedUser, username, ObjectPermission.Type.READ)) {
            return this.getObjectInstances(this.userRecordMapper.select(username));
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    public List<ActivityRecord> retrieveHistory(ModeledAuthenticatedUser user, Collection<ActivityRecordSearchTerm> requiredContents, List<ActivityRecordSortPredicate> sortPredicates, int limit) throws GuacamoleException {
        List<ActivityRecordModel> searchResults = user.isPrivileged() ? this.userRecordMapper.search(requiredContents, sortPredicates, limit) : this.userRecordMapper.searchReadable((UserModel)user.getUser().getModel(), requiredContents, sortPredicates, limit, user.getEffectiveUserGroups());
        return this.getObjectInstances(searchResults);
    }
}

