/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.usergroup;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.usergroup.ModeledUserGroup;
import org.apache.guacamole.auth.jdbc.usergroup.UserGroupService;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.UserGroup;
import org.mybatis.guice.transactional.Transactional;

public class UserGroupDirectory
extends RestrictedObject
implements Directory<UserGroup> {
    @Inject
    private UserGroupService userGroupService;

    public UserGroup get(String identifier) throws GuacamoleException {
        return (UserGroup)this.userGroupService.retrieveObject(this.getCurrentUser(), identifier);
    }

    @Transactional
    public Collection<UserGroup> getAll(Collection<String> identifiers) throws GuacamoleException {
        Collection objects = this.userGroupService.retrieveObjects(this.getCurrentUser(), identifiers);
        return Collections.unmodifiableCollection(objects);
    }

    @Transactional
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.userGroupService.getIdentifiers(this.getCurrentUser());
    }

    @Transactional
    public void add(UserGroup object) throws GuacamoleException {
        this.userGroupService.createObject(this.getCurrentUser(), object);
    }

    @Transactional
    public void update(UserGroup object) throws GuacamoleException {
        ModeledUserGroup group = (ModeledUserGroup)object;
        this.userGroupService.updateObject(this.getCurrentUser(), group);
    }

    @Transactional
    public void remove(String identifier) throws GuacamoleException {
        this.userGroupService.deleteObject(this.getCurrentUser(), identifier);
    }
}

