/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.cas.conf.ConfigurationService;
import org.apache.guacamole.auth.cas.form.CASTicketField;
import org.apache.guacamole.auth.cas.ticket.TicketValidationService;
import org.apache.guacamole.auth.cas.user.CASAuthenticatedUser;
import org.apache.guacamole.form.Field;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

public class AuthenticationProviderService {
    @Inject
    private ConfigurationService confService;
    @Inject
    private TicketValidationService ticketService;
    @Inject
    private Provider<CASAuthenticatedUser> authenticatedUserProvider;

    public CASAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        String ticket;
        HttpServletRequest request = credentials.getRequest();
        if (request != null && (ticket = request.getParameter("ticket")) != null) {
            Map<String, String> tokens = this.ticketService.validateTicket(ticket, credentials);
            String username = credentials.getUsername();
            if (username != null) {
                CASAuthenticatedUser authenticatedUser = this.authenticatedUserProvider.get();
                authenticatedUser.init(username, credentials, tokens);
                return authenticatedUser;
            }
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login.", new CredentialsInfo(Arrays.asList(new Field[]{new CASTicketField(this.confService.getAuthorizationEndpoint(), this.confService.getRedirectURI(), new TranslatableMessage("LOGIN.INFO_CAS_REDIRECT_PENDING"))})));
    }
}

