/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid.form;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.guacamole.form.Field;

public class TokenField
extends Field {
    public static final String PARAMETER_NAME = "id_token";
    private final String authorizationURI;

    public TokenField(String authorizationEndpoint, String scope, String clientID, String redirectURI, String nonce) {
        super(PARAMETER_NAME, "GUAC_OPENID_TOKEN");
        try {
            this.authorizationURI = authorizationEndpoint + "?scope=" + URLEncoder.encode(scope, "UTF-8") + "&response_type=id_token&client_id=" + URLEncoder.encode(clientID, "UTF-8") + "&redirect_uri=" + URLEncoder.encode(redirectURI, "UTF-8") + "&nonce=" + nonce;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Unexpected lack of UTF-8 support.", e);
        }
    }

    public String getAuthorizationURI() {
        return this.authorizationURI;
    }
}

