/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.openid.conf;

import com.google.inject.Inject;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.properties.IntegerGuacamoleProperty;
import org.apache.guacamole.properties.StringGuacamoleProperty;

public class ConfigurationService {
    private static final String DEFAULT_USERNAME_CLAIM_TYPE = "email";
    private static final String DEFAULT_SCOPE = "openid email profile";
    private static final int DEFAULT_ALLOWED_CLOCK_SKEW = 30;
    private static final int DEFAULT_MAX_TOKEN_VALIDITY = 300;
    private static final int DEFAULT_MAX_NONCE_VALIDITY = 10;
    private static final StringGuacamoleProperty OPENID_AUTHORIZATION_ENDPOINT = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-authorization-endpoint";
        }
    };
    private static final StringGuacamoleProperty OPENID_JWKS_ENDPOINT = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-jwks-endpoint";
        }
    };
    private static final StringGuacamoleProperty OPENID_ISSUER = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-issuer";
        }
    };
    private static final StringGuacamoleProperty OPENID_USERNAME_CLAIM_TYPE = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-username-claim-type";
        }
    };
    private static final StringGuacamoleProperty OPENID_SCOPE = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-scope";
        }
    };
    private static final IntegerGuacamoleProperty OPENID_ALLOWED_CLOCK_SKEW = new IntegerGuacamoleProperty(){

        public String getName() {
            return "openid-allowed-clock-skew";
        }
    };
    private static final IntegerGuacamoleProperty OPENID_MAX_TOKEN_VALIDITY = new IntegerGuacamoleProperty(){

        public String getName() {
            return "openid-max-token-validity";
        }
    };
    private static final IntegerGuacamoleProperty OPENID_MAX_NONCE_VALIDITY = new IntegerGuacamoleProperty(){

        public String getName() {
            return "openid-max-nonce-validity";
        }
    };
    private static final StringGuacamoleProperty OPENID_CLIENT_ID = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-client-id";
        }
    };
    private static final StringGuacamoleProperty OPENID_REDIRECT_URI = new StringGuacamoleProperty(){

        public String getName() {
            return "openid-redirect-uri";
        }
    };
    @Inject
    private Environment environment;

    public String getAuthorizationEndpoint() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)OPENID_AUTHORIZATION_ENDPOINT);
    }

    public String getClientID() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)OPENID_CLIENT_ID);
    }

    public String getRedirectURI() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)OPENID_REDIRECT_URI);
    }

    public String getIssuer() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)OPENID_ISSUER);
    }

    public String getJWKSEndpoint() throws GuacamoleException {
        return (String)this.environment.getRequiredProperty((GuacamoleProperty)OPENID_JWKS_ENDPOINT);
    }

    public String getUsernameClaimType() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)OPENID_USERNAME_CLAIM_TYPE, (Object)DEFAULT_USERNAME_CLAIM_TYPE);
    }

    public String getScope() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)OPENID_SCOPE, (Object)DEFAULT_SCOPE);
    }

    public int getAllowedClockSkew() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)OPENID_ALLOWED_CLOCK_SKEW, (Object)30);
    }

    public int getMaxTokenValidity() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)OPENID_MAX_TOKEN_VALIDITY, (Object)300);
    }

    public int getMaxNonceValidity() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)OPENID_MAX_NONCE_VALIDITY, (Object)10);
    }
}

